var _cube,
	texCtx;

var plane;

var _cubeCluster = [];
var cubeCount = 0;
var texStep = 0;
var BAR_MAX_HEIGHT = 10;
var HEIGHTMAP_WIDTH = 280;

var FIELD_SIZE_X = 16;
var FIELD_SIZE_Y = 24;
  
var cubeMaterials = [];
var cubeWave01Holder;

					//left, right, top, bottom, front, back
var CUBE_COLORS = [	[0x1c0006,0x110003,0x260e12,0x060001,0x260209,0x000000],
					[0x39000b,0x220007,0x4c1b24,0x0c0002,0x4c0412,0x000000],
					[0x560011,0x34000a,0x732937,0x120004,0x73061c,0x000000],
					[0x730017,0x45000e,0x993749,0x170005,0x990825,0x000000],
					[0x8f001c,0x560011,0xbf455b,0x1d0006,0xbf0a2e,0x000000],
					[0xac0022,0x670015,0xe5536e,0x230007,0xe50c37,0x000000],
					[0xbf0026,0x730017,0xff5c7a,0x270008,0xff0d3d,0x000000]];

function initScene01() {
	
    var CUBE_DIAMETER = 10;
    
    cubeWave01Holder = new THREE.Object3D();    
    
	for ( var i = 0; i < 5; i ++ ) {

		cubeMaterials.push( [ new THREE.MeshBasicMaterial( { color: CUBE_COLORS[0][i] } ) ] );
	}

	var geometry = new Cube( CUBE_DIAMETER, CUBE_DIAMETER, CUBE_DIAMETER, 1, 1, 1, cubeMaterials );

    for (var a = 0; a < FIELD_SIZE_X; a++) {
		
    	_cubeCluster[a] = [];
    	
        for (var b = 0; b < FIELD_SIZE_Y; b++) {

            _cube = new THREE.Mesh(geometry, new THREE.MeshFaceMaterial() );
            _cube.position.x = (a * CUBE_DIAMETER);
            _cube.position.y = (b * CUBE_DIAMETER);

            _cube.scale.z = 1;

            _cubeCluster[a][b] = _cube;
            
            //scene.addObject( _cube );
            cubeWave01Holder.addChild( _cube );

            cubeCount++;
        }
    }

	scene.addChild(cubeWave01Holder);

    renderer.autoClear = false;

    camera = new THREE.Camera(60, window.innerWidth / window.innerHeight, 1, 1000, _cubeCluster[7][7]);

    camera.position.x = 120;
    camera.position.y = 250;
    camera.position.z = 86;
};

var countUp = 0;
var materialNeedsUpdate = true;
var tint = 0;
function changeWave01Color() {
	
	countUp++;
	
	if(countUp >= 12) {
		
		tint++;
		
		for (i = 0; i < 5; i++)	{

			cubeMaterials[i][0].color.setHex( CUBE_COLORS[tint][i] );
		}
		
		countUp = 0;
	}
}

function updateCubeHeights() {

	var row = 0;
	var element = 0;
	
	var eqStep = Math.round((870 / 30) * elapsed);

	for (var a = 0; a < FIELD_SIZE_X; a++) {
		
        for (var b = 0; b < FIELD_SIZE_Y; b++) {
        	
        	if((eqStep + b) < eqData.length) {
	        	var scale = eqData[eqStep + b][a];
	        	scale = scale > 0 ? scale * 10 : .1;
	        	_cubeCluster[a][b].scale.z = scale;
	        }
		}
    }
};

function renderScene01() {
	
	//480px to travel from 250 to -230
    camera.position.y = 250 - (480 / 33) * elapsed;
	
	renderer.clear();
	
    renderer.render(scene, camera);
};


var wave01Scale = 1;
function goodbyeWave01() {
	
	if( (milli > .1) && (milli < .25) )
		wave01Scale -= .15;
	
	if(wave01Scale < 0)	
		wave01Scale = .1;
		
	//cubeWave01Holder.scale.x = wave01Scale;
	//cubeWave01Holder.scale.y = wave01Scale;
	cubeWave01Holder.scale.z = wave01Scale;
	
	renderScene01();
}

function clearScene01() {
	
	for (var a = 0; a < FIELD_SIZE_X; a++) {
		
        for (var b = 0; b < FIELD_SIZE_Y; b++) {
        	
        	_cubeCluster[a][b].visible = false;
    	}
    }
}

var eqData = [[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0.22,0.27,0.42,0.43,0.36,0.04,0.58,0,0,0.34,0.11,0.2,0.27,0.1,0.32,0.03],
[0.12,0.65,0.4,0.25,0.28,0.25,0.39,0.44,0.15,0.15,0.23,0.28,0.18,0.45,0,0],
[0.12,0.65,0.4,0.25,0.28,0.25,0.39,0.44,0.15,0.15,0.23,0.28,0.18,0.45,0,0],
[0.46,0.37,0.41,0.01,0.26,0.45,0.38,0.22,0,0,0.27,0,0.22,0,0.36,0.11],
[0,0.56,0,0,0,0.17,0.42,0.21,0.36,0.33,0.14,0,0.22,0.16,0,0.2],
[0,0.56,0,0,0,0.17,0.42,0.21,0.36,0.33,0.14,0,0.22,0.16,0,0.2],
[0,0.34,0.53,0.42,0.5,0.32,0.13,0.35,0.48,0,0.24,0,0.24,0.2,0.37,0.26],
[0,0.18,0.57,0.47,0.16,0.34,0.05,0.3,0,0.4,0,0.06,0.31,0.02,0,0.46],
[0,0.55,0.32,0.31,0.57,0.09,0,0.16,0.21,0,0,0,0.24,0,0.09,0.43],
[0,0.55,0.32,0.31,0.57,0.09,0,0.16,0.21,0,0,0,0.24,0,0.09,0.43],
[0.15,0.49,0.37,0.34,0.4,0.47,0.3,0.28,0,0.02,0.6,0,0,0,0.42,0.28],
[0.45,0,0.68,0.19,0.49,0.18,0.15,0.32,0.34,0.49,0.45,0.33,0.42,0,0.32,0.27],
[0.45,0,0.68,0.19,0.49,0.18,0.15,0.32,0.34,0.49,0.45,0.33,0.42,0,0.32,0.27],
[0,0.52,0.4,0.49,0.32,0.56,0.21,0.17,0.36,0.43,0.29,0.13,0.08,0.25,0,0],
[0,0,0.02,0.39,0.47,0.25,0.47,0.45,0.38,0.3,0.24,0,0.54,0.2,0.48,0.21],
[0.33,0,0.5,0,0.58,0,0.57,0.34,0.14,0.15,0,0,0,0.6,0.11,0.04],
[0.33,0,0.5,0,0.58,0,0.57,0.34,0.14,0.15,0,0,0,0.6,0.11,0.04],
[0.49,0,0.54,0.38,0.4,0,0.38,0,0,0.13,0,0,0.53,0.18,0.48,0.07],
[0.39,0,0.58,0.71,0,0.21,0.19,0.49,0.18,0.18,0,0.18,0.08,0.64,0.15,0.18],
[0.39,0,0.58,0.71,0,0.21,0.19,0.49,0.18,0.18,0,0.18,0.08,0.64,0.15,0.18],
[0.03,0.3,0.04,0.59,0.57,0.24,0.21,0.16,0.42,0.24,0,0,0.34,0.21,0.54,0.23],
[0,0.1,0.2,0.37,0.53,0.28,0.28,0.08,0.45,0,0.31,0.3,0.27,0.44,0.11,0.26],
[0,0.54,0.16,0.67,0.4,0.12,0.21,0.27,0.28,0,0,0,0.33,0,0,0.39],
[0,0.54,0.16,0.67,0.4,0.12,0.21,0.27,0.28,0,0,0,0.33,0,0,0.39],
[0.33,0.14,0.38,0.44,0.7,0.06,0.28,0.36,0.36,0.16,0.58,0.01,0.2,0,0.18,0],
[0,0.35,0.29,0.09,0.45,0.62,0.38,0.22,0.28,0.59,0,0.29,0,0.24,0.4,0],
[0,0.35,0.29,0.09,0.45,0.62,0.38,0.22,0.28,0.59,0,0.29,0,0.24,0.4,0],
[0.37,0.12,0.54,0.49,0.41,0.47,0,0.16,0.39,0.52,0.46,0.39,0.11,0.38,0.43,0.23],
[0.29,0,0.42,0,0.42,0.23,0.25,0.24,0.3,0.12,0.47,0,0.49,0.52,0.23,0.46],
[0.19,0.06,0.29,0.41,0,0.27,0.33,0.34,0.12,0,0.47,0,0.27,0.48,0.23,0],
[0.19,0.06,0.29,0.41,0,0.27,0.33,0.34,0.12,0,0.47,0,0.27,0.48,0.23,0],
[0.36,0.28,0.45,0.3,0.15,0.1,0.39,0.13,0.33,0.41,0,0.03,0.49,0.49,0.49,0.29],
[0,0,0,0.49,0,0.32,0.18,0.54,0.29,0.35,0.29,0.1,0.54,0.61,0,0],
[0,0.26,0,0.43,0.35,0.05,0,0.48,0.29,0.17,0.35,0.19,0.45,0.45,0.12,0.31],
[0,0.26,0,0.43,0.35,0.05,0,0.48,0.29,0.17,0.35,0.19,0.45,0.45,0.12,0.31],
[0,0,0,0.5,0.21,0,0.2,0.51,0.46,0.07,0,0.32,0.22,0.54,0.37,0.53],
[0.01,0,0.28,0.26,0.41,0.41,0.12,0,0.06,0.31,0,0.27,0.37,0.23,0.06,0.44],
[0.01,0,0.28,0.26,0.41,0.41,0.12,0,0.06,0.31,0,0.27,0.37,0.23,0.06,0.44],
[0,0.09,0.47,0.52,0.53,0.46,0,0.54,0.34,0.39,0.47,0,0.12,0,0.31,0.06],
[0.07,0.2,0.09,0.46,0.55,0.22,0.11,0.21,0,0.54,0.28,0.12,0.3,0.29,0.21,0.27],
[0,0.36,0,0,0.05,0.44,0,0.33,0.41,0.21,0.57,0.08,0.17,0,0.33,0],
[0,0.36,0,0,0.05,0.44,0,0.33,0.41,0.21,0.57,0.08,0.17,0,0.33,0],
[0,0,0.13,0.56,0.24,0.06,0.39,0.42,0,0.3,0,0,0.33,0.53,0.33,0],
[0,0.27,0,0.69,0,0.26,0.08,0.22,0.08,0.23,0.24,0.12,0.53,0.23,0.41,0.15],
[0,0.27,0,0.69,0,0.26,0.08,0.22,0.08,0.23,0.24,0.12,0.53,0.23,0.41,0.15],
[0,0.22,0,0.68,0.27,0.22,0.13,0,0.3,0,0.49,0.18,0.45,0.59,0.35,0],
[0.22,0.3,0.39,0,0.36,0.06,0.24,0.4,0.38,0.37,0,0,0.39,0.5,0,0.46],
[0.14,0,0.32,0,0.41,0.09,0.15,0.53,0.52,0.32,0,0.09,0.39,0.22,0,0.37],
[0.14,0,0.32,0,0.41,0.09,0.15,0.53,0.52,0.32,0,0.09,0.39,0.22,0,0.37],
[0,0.03,0,0.51,0,0.45,0.03,0.44,0.55,0,0.14,0.45,0.5,0.32,0.41,0.31],
[0,0,0,0.04,0.56,0,0,0.34,0.34,0.25,0.14,0.34,0.03,0.48,0.24,0.34],
[0,0,0,0.04,0.56,0,0,0.34,0.34,0.25,0.14,0.34,0.03,0.48,0.24,0.34],
[0.2,0,0.19,0.33,0.45,0.56,0.49,0.18,0.31,0.28,0,0.21,0.29,0.29,0.41,0.12],
[0.2,0,0.08,0.24,0,0.66,0.45,0.19,0.4,0.15,0.52,0.13,0,0.15,0,0],
[0.3,0,0.44,0.26,0.56,0.12,0.55,0,0.29,0.37,0.18,0,0.1,0.19,0.31,0.34],
[0.3,0,0.44,0.26,0.56,0.12,0.55,0,0.29,0.37,0.18,0,0.1,0.19,0.31,0.34],
[0.17,0.06,0.33,0.48,0.49,0,0.2,0.37,0.33,0.28,0.32,0.37,0.22,0.57,0.2,0.24],
[0.23,0.26,0.29,0,0.33,0,0.32,0.11,0.23,0.57,0.06,0.08,0.56,0,0.45,0],
[0.23,0.26,0.29,0,0.33,0,0.32,0.11,0.23,0.57,0.06,0.08,0.56,0,0.45,0],
[0,0,0.08,0.3,0.35,0.34,0.09,0,0.43,0.42,0.33,0.28,0.4,0.71,0.39,0],
[0,0.4,0.06,0.46,0,0.19,0.51,0.46,0.49,0.3,0,0.24,0.55,0.45,0.41,0.45],
[0,0.16,0.22,0.31,0.3,0.48,0.2,0.62,0.17,0.38,0,0.2,0.27,0.49,0.48,0.34],
[0,0.16,0.22,0.31,0.3,0.48,0.2,0.62,0.17,0.38,0,0.2,0.27,0.49,0.48,0.34],
[0,0.17,0,0.29,0,0.12,0.22,0.03,0.5,0.1,0,0.46,0.06,0.48,0.31,0.11],
[0.2,0.16,0.27,0.08,0,0.26,0,0.41,0.32,0.11,0.02,0.45,0.33,0.32,0.23,0.02],
[0.2,0.16,0.27,0.08,0,0.26,0,0.41,0.32,0.11,0.02,0.45,0.33,0.32,0.23,0.02],
[0.13,0,0.13,0,0.48,0.64,0.38,0,0.2,0.25,0.55,0.27,0,0.13,0.49,0.34],
[0.24,0.1,0.32,0.24,0.39,0.62,0.34,0.36,0.4,0.33,0.35,0.12,0.32,0.3,0.09,0.43],
[0.37,0.02,0.42,0.19,0.63,0.25,0.52,0.24,0.37,0.31,0.5,0,0.35,0.39,0.18,0.34],
[0.37,0.02,0.42,0.19,0.63,0.25,0.52,0.24,0.37,0.31,0.5,0,0.35,0.39,0.18,0.34],
[0.09,0,0.09,0,0.25,0.44,0.16,0.06,0,0.26,0,0.18,0.39,0.34,0.47,0.02],
[0,0,0,0,0,0.14,0.53,0.31,0.26,0.01,0.2,0.1,0.18,0.54,0.2,0],
[0.02,0.03,0.03,0,0.38,0.22,0.31,0.22,0,0.13,0.1,0.25,0,0.5,0.2,0.18],
[0.02,0.03,0.03,0,0.38,0.22,0.31,0.22,0,0.13,0.1,0.25,0,0.5,0.2,0.18],
[0.06,0,0.01,0,0,0.2,0.32,0.48,0.53,0.37,0.07,0.29,0.17,0,0.43,0.33],
[0,0,0,0.35,0,0,0.02,0.44,0.53,0.21,0,0,0,0.33,0,0.49],
[0,0,0,0.35,0,0,0.02,0.44,0.53,0.21,0,0,0,0.33,0,0.49],
[0,0.18,0.03,0.43,0.26,0,0.13,0.2,0.29,0.28,0.06,0,0.37,0.45,0.33,0.46],
[0.15,0.27,0.22,0.46,0.51,0,0.24,0,0.22,0.28,0.07,0,0.43,0.18,0,0.13],
[0.34,0.17,0.36,0.41,0.51,0.2,0.3,0.23,0.42,0.32,0.55,0.18,0.31,0.16,0.43,0.24],
[0.34,0.17,0.36,0.41,0.51,0.2,0.3,0.23,0.42,0.32,0.55,0.18,0.31,0.16,0.43,0.24],
[0.29,0,0.34,0,0.41,0.57,0.42,0.17,0.32,0.33,0.14,0.07,0,0,0.07,0.27],
[0,0,0,0,0,0.64,0.08,0.19,0.16,0.37,0,0,0,0.02,0,0.29],
[0,0,0,0,0,0.64,0.08,0.19,0.16,0.37,0,0,0,0.02,0,0.29],
[0,0.08,0,0,0,0.4,0.48,0.55,0.36,0,0.14,0.28,0.47,0,0.19,0.15],
[0.11,0.01,0.15,0.06,0.22,0,0.67,0.38,0.37,0.1,0.46,0,0.34,0.41,0.34,0.06],
[0,0,0.1,0,0.29,0,0.46,0.3,0.16,0,0,0.04,0.24,0.56,0.44,0],
[0,0,0.1,0,0.29,0,0.46,0.3,0.16,0,0,0.04,0.24,0.56,0.44,0],
[0,0.14,0,0.15,0.09,0.39,0,0.43,0.54,0.31,0,0.19,0.37,0.44,0.37,0.38],
[0,0,0,0,0,0,0.41,0.41,0.52,0,0.15,0.08,0.32,0.27,0.28,0.64],
[0,0,0,0,0,0,0.41,0.41,0.52,0,0.15,0.08,0.32,0.27,0.28,0.64],
[0,0,0,0.12,0,0,0.29,0,0.36,0,0,0,0,0,0.47,0.61],
[0.31,0.16,0.34,0.37,0,0.31,0.1,0.2,0.11,0.4,0.18,0.17,0.34,0.03,0.4,0.13],
[0.22,0.02,0.27,0,0.56,0.51,0.41,0.25,0.43,0.25,0.39,0.15,0.09,0.42,0.25,0.26],
[0.22,0.02,0.27,0,0.56,0.51,0.41,0.25,0.43,0.25,0.39,0.15,0.09,0.42,0.25,0.26],
[0.29,0.06,0.37,0.3,0.51,0.54,0.53,0.36,0.43,0.34,0,0.27,0,0,0.45,0.2],
[0,0,0.02,0,0.35,0.69,0,0,0.05,0.23,0.4,0,0.27,0.13,0.38,0],
[0,0,0.02,0,0.35,0.69,0,0,0.05,0.23,0.4,0,0.27,0.13,0.38,0],
[0,0,0,0,0,0.3,0.57,0.36,0,0,0,0.23,0.34,0.49,0.41,0.24],
[0.01,0,0.05,0,0.25,0.29,0.63,0.19,0.41,0.31,0.34,0,0.42,0,0.03,0.13],
[0.11,0.15,0.16,0.23,0.23,0.38,0.53,0.53,0.26,0.25,0.04,0.15,0.03,0.29,0.13,0],
[0.11,0.15,0.16,0.23,0.23,0.38,0.53,0.53,0.26,0.25,0.04,0.15,0.03,0.29,0.13,0],
[0,0,0,0,0,0.16,0.28,0.33,0,0.34,0.18,0,0,0.14,0,0.62],
[0,0.13,0,0.18,0,0,0.4,0.61,0.22,0.2,0.07,0.18,0,0.34,0.4,0.6],
[0,0.13,0,0.18,0,0,0.4,0.61,0.22,0.2,0.07,0.18,0,0.34,0.4,0.6],
[0,0,0,0,0,0.13,0.08,0.32,0.57,0.33,0.45,0.12,0.52,0.05,0.5,0.04],
[0.15,0,0.09,0,0.21,0.04,0.16,0.3,0.36,0,0.38,0.31,0.2,0.36,0.31,0.23],
[0.05,0,0.03,0,0.11,0,0.24,0.45,0.06,0.39,0.3,0.27,0.09,0,0.15,0.2],
[0.05,0,0.03,0,0.11,0,0.24,0.45,0.06,0.39,0.3,0.27,0.09,0,0.15,0.2],
[0,0,0,0.04,0.15,0,0.11,0.09,0,0.1,0.71,0,0.35,0,0.13,0.22],
[0,0.1,0,0.03,0,0.47,0.13,0.46,0.03,0.63,0.38,0.42,0,0,0,0.28],
[0.16,0.64,0.14,0.42,0.54,0.56,0,0.03,0.32,0.43,0.14,0.25,0.25,0,0.34,0],
[0.16,0.64,0.14,0.42,0.54,0.56,0,0.03,0.32,0.43,0.14,0.25,0.25,0,0.34,0],
[0.51,0.62,0.35,0.1,0.31,0,0.59,0.39,0.37,0.16,0.13,0.04,0.13,0,0,0],
[0.65,0.51,0.27,0.4,0.2,0.6,0.18,0.28,0.22,0.21,0.12,0.3,0.34,0.15,0,0],
[0.65,0.51,0.27,0.4,0.2,0.6,0.18,0.28,0.22,0.21,0.12,0.3,0.34,0.15,0,0],
[0,0.41,0.59,0.46,0,0.16,0.45,0,0,0.13,0,0.26,0.35,0.5,0,0],
[0.44,0.56,0,0.58,0.38,0,0.46,0,0.19,0.15,0.17,0.03,0,0.28,0.22,0.22],
[0.32,0.54,0.29,0.55,0,0,0,0.36,0.14,0.25,0,0.29,0.52,0.18,0.32,0.31],
[0.32,0.54,0.29,0.55,0,0,0,0.36,0.14,0.25,0,0.29,0.52,0.18,0.32,0.31],
[0.33,0.44,0.36,0.68,0,0.2,0,0.14,0.35,0.08,0,0.49,0.2,0,0.09,0.04],
[0.02,0.41,0.54,0,0.61,0.39,0.53,0.14,0.4,0.13,0.1,0.38,0.24,0.06,0,0.19],
[0.02,0.41,0.54,0,0.61,0.39,0.53,0.14,0.4,0.13,0.1,0.38,0.24,0.06,0,0.19],
[0.01,0.04,0.38,0.63,0,0.22,0.4,0.37,0.41,0,0.22,0,0.29,0,0.39,0.47],
[0.25,0.53,0.32,0.15,0.57,0.19,0.26,0.29,0.37,0,0.13,0.37,0.25,0,0,0.15],
[0.05,0.35,0.4,0.46,0.2,0.69,0.19,0.37,0.42,0.66,0.23,0.34,0.26,0,0.03,0.21],
[0.05,0.35,0.4,0.46,0.2,0.69,0.19,0.37,0.42,0.66,0.23,0.34,0.26,0,0.03,0.21],
[0.25,0.42,0.4,0.49,0.3,0.45,0.49,0,0.28,0.45,0.55,0.33,0.42,0.26,0,0.43],
[0.23,0.31,0.55,0.16,0.55,0.23,0.25,0,0.3,0.28,0.6,0,0,0.21,0.23,0.13],
[0.23,0.31,0.55,0.16,0.55,0.23,0.25,0,0.3,0.28,0.6,0,0,0.21,0.23,0.13],
[0,0.67,0.48,0.38,0.3,0.22,0.53,0,0.34,0.41,0.05,0.26,0.32,0.23,0.22,0.25],
[0.39,0.48,0.37,0.43,0.58,0.1,0,0.38,0,0.51,0,0.3,0.43,0.24,0,0.22],
[0.07,0.38,0.48,0.63,0.36,0.38,0.19,0.42,0.4,0,0.4,0.58,0,0.49,0.09,0.18],
[0.07,0.38,0.48,0.63,0.36,0.38,0.19,0.42,0.4,0,0.4,0.58,0,0.49,0.09,0.18],
[0.32,0.42,0,0.61,0.35,0.39,0.18,0.3,0.44,0,0.27,0.4,0.2,0.03,0.12,0],
[0,0.16,0.29,0.22,0.56,0.23,0.47,0.5,0.4,0.18,0.36,0.33,0.27,0.33,0.2,0],
[0,0.16,0.29,0.22,0.56,0.23,0.47,0.5,0.4,0.18,0.36,0.33,0.27,0.33,0.2,0],
[0,0.47,0.28,0.48,0.43,0,0.04,0.62,0.44,0.3,0.32,0.38,0.38,0,0.26,0.17],
[0.27,0.18,0.61,0.13,0.49,0.4,0,0.31,0,0.25,0,0,0.32,0,0.18,0.14],
[0.01,0.36,0.53,0.27,0.27,0.62,0.01,0.19,0.42,0.51,0.39,0.49,0.12,0,0.35,0.33],
[0.01,0.36,0.53,0.27,0.27,0.62,0.01,0.19,0.42,0.51,0.39,0.49,0.12,0,0.35,0.33],
[0.42,0.23,0.59,0.13,0.28,0.43,0.48,0.18,0.07,0.08,0.46,0.32,0.19,0.27,0.4,0.33],
[0.19,0.45,0,0.41,0.5,0.63,0.22,0.34,0,0.08,0.42,0.3,0.25,0.14,0.19,0.18],
[0.19,0.45,0,0.41,0.5,0.63,0.22,0.34,0,0.08,0.42,0.3,0.25,0.14,0.19,0.18],
[0.33,0,0.5,0.6,0.07,0.42,0.6,0.5,0,0.35,0,0.29,0,0.48,0,0.4],
[0.34,0.15,0.54,0.56,0.58,0.29,0.52,0.52,0,0.27,0.27,0.25,0.42,0,0.27,0.17],
[0.44,0.19,0.44,0,0.32,0.37,0.22,0.38,0.18,0.43,0.27,0.5,0.38,0.39,0.08,0.11],
[0.44,0.19,0.44,0,0.32,0.37,0.22,0.38,0.18,0.43,0.27,0.5,0.38,0.39,0.08,0.11],
[0.23,0,0,0.33,0,0.39,0.41,0.1,0.45,0,0,0.25,0.49,0.27,0.27,0],
[0,0.23,0.14,0.32,0.58,0.11,0.34,0.27,0.37,0.22,0.27,0.2,0.47,0,0,0],
[0,0.48,0.15,0.41,0.24,0.32,0.49,0.13,0.56,0.28,0.05,0.13,0,0,0.08,0.13],
[0,0.48,0.15,0.41,0.24,0.32,0.49,0.13,0.56,0.28,0.05,0.13,0,0,0.08,0.13],
[0,0.5,0.36,0.27,0.54,0.31,0.02,0.44,0.55,0.32,0.28,0.4,0.14,0.3,0.09,0],
[0.33,0,0.6,0.09,0.5,0.15,0.55,0.47,0.39,0.49,0.3,0.2,0.33,0.28,0.16,0],
[0.33,0,0.6,0.09,0.5,0.15,0.55,0.47,0.39,0.49,0.3,0.2,0.33,0.28,0.16,0],
[0,0.41,0.4,0.45,0.48,0.48,0.41,0.37,0.45,0.37,0.49,0.28,0.29,0.23,0.14,0.06],
[0,0.47,0.42,0.44,0.54,0.43,0.25,0,0.35,0.48,0.46,0.26,0,0,0,0],
[0.01,0,0,0.15,0.02,0.17,0.64,0,0.01,0.57,0.31,0.38,0.49,0.31,0,0.16],
[0.01,0,0,0.15,0.02,0.17,0.64,0,0.01,0.57,0.31,0.38,0.49,0.31,0,0.16],
[0,0.15,0.09,0.54,0.06,0.47,0.56,0.53,0.32,0.44,0.53,0,0.2,0.25,0,0.18],
[0,0.25,0,0.58,0.11,0.27,0.61,0.4,0,0.22,0.34,0.26,0.57,0.35,0,0.16],
[0,0.25,0,0.58,0.11,0.27,0.61,0.4,0,0.22,0.34,0.26,0.57,0.35,0,0.16],
[0.33,0.34,0.38,0.52,0.63,0.25,0.55,0.57,0.4,0.29,0,0.4,0.42,0,0.08,0.56],
[0.32,0.34,0.43,0.59,0.39,0.33,0.51,0.36,0.43,0.01,0.34,0.05,0.03,0.45,0.5,0.51],
[0.12,0.1,0.36,0.28,0.52,0.33,0.31,0.3,0.41,0.18,0.34,0.49,0.15,0.1,0.48,0.18],
[0.12,0.1,0.36,0.28,0.52,0.33,0.31,0.3,0.41,0.18,0.34,0.49,0.15,0.1,0.48,0.18],
[0.19,0.45,0.16,0.35,0.53,0.46,0.59,0.15,0,0.26,0.36,0.27,0,0,0,0],
[0.18,0,0.23,0.57,0.65,0.15,0.19,0.54,0.52,0.26,0.55,0.26,0,0.18,0.07,0.21],
[0.18,0,0.23,0.57,0.65,0.15,0.19,0.54,0.52,0.26,0.55,0.26,0,0.18,0.07,0.21],
[0.38,0.46,0.39,0.54,0.21,0.53,0.01,0.16,0.53,0.36,0.33,0.19,0.2,0.18,0,0.28],
[0.35,0.21,0.58,0,0.37,0.53,0.54,0.05,0.25,0.47,0.47,0.17,0.28,0,0.18,0],
[0.14,0.14,0.3,0.29,0.25,0,0.55,0.39,0.08,0.27,0.39,0.04,0.54,0.19,0.08,0.25],
[0.14,0.14,0.3,0.29,0.25,0,0.55,0.39,0.08,0.27,0.39,0.04,0.54,0.19,0.08,0.25],
[0.21,0.03,0.41,0.36,0.43,0.14,0.5,0.52,0,0.64,0,0.18,0.24,0.39,0,0],
[0,0.08,0,0,0,0.57,0,0.48,0.21,0.03,0.49,0.31,0.45,0.5,0.07,0.12],
[0,0.08,0,0,0,0.57,0,0.48,0.21,0.03,0.49,0.31,0.45,0.5,0.07,0.12],
[0,0.18,0.19,0.43,0,0.46,0.17,0.29,0.06,0.3,0.58,0.27,0.34,0.18,0.24,0.56],
[0,0.15,0.21,0.13,0.52,0,0.33,0.3,0.29,0.36,0.22,0.1,0.38,0.47,0.57,0.35],
[0.01,0.22,0.01,0.35,0,0,0,0.03,0.38,0.03,0.07,0.14,0.5,0.09,0.58,0],
[0.01,0.22,0.01,0.35,0,0,0,0.03,0.38,0.03,0.07,0.14,0.5,0.09,0.58,0],
[0.21,0.06,0.29,0,0.2,0.39,0.39,0.15,0,0.33,0.52,0.19,0,0.33,0.6,0.44],
[0.2,0.15,0.25,0.37,0.52,0.46,0.12,0.19,0,0.35,0.39,0.31,0.2,0.23,0.05,0.52],
[0.2,0.15,0.25,0.37,0.52,0.46,0.12,0.19,0,0.35,0.39,0.31,0.2,0.23,0.05,0.52],
[0.21,0,0.23,0,0,0.5,0.39,0.16,0.04,0.25,0.39,0.24,0.22,0,0.12,0.17],
[0,0.24,0,0.28,0.34,0.61,0,0.39,0,0,0.11,0,0,0.05,0,0.33],
[0.16,0.31,0.32,0.53,0.32,0,0.5,0.39,0.35,0.32,0.43,0.37,0.36,0.43,0.35,0.25],
[0.16,0.31,0.32,0.53,0.32,0,0.5,0.39,0.35,0.32,0.43,0.37,0.36,0.43,0.35,0.25],
[0.41,0.41,0.54,0.36,0.02,0.41,0.19,0.31,0.14,0.44,0.51,0.4,0.31,0.21,0.14,0],
[0.29,0,0.42,0.3,0.28,0.27,0.73,0.52,0.35,0.47,0.31,0.32,0.13,0.42,0,0.24],
[0.01,0.39,0,0.58,0.56,0,0.2,0.62,0.45,0.18,0.14,0,0.01,0.24,0.51,0],
[0.01,0.39,0,0.58,0.56,0,0.2,0.62,0.45,0.18,0.14,0,0.01,0.24,0.51,0],
[0.35,0.06,0.41,0.41,0.41,0.49,0.4,0.32,0.49,0.21,0,0.48,0.41,0.03,0.53,0.45],
[0.07,0.18,0.28,0.55,0.45,0.42,0.41,0.13,0.53,0.1,0.31,0.2,0.29,0.35,0.39,0.47],
[0.07,0.18,0.28,0.55,0.45,0.42,0.41,0.13,0.53,0.1,0.31,0.2,0.29,0.35,0.39,0.47],
[0.35,0,0.43,0.02,0.13,0,0.34,0.24,0,0.37,0.21,0.03,0.23,0,0,0.15],
[0,0.12,0,0.32,0,0.22,0.19,0.2,0,0.16,0.48,0,0.21,0,0.31,0.2],
[0,0.1,0,0.36,0.49,0,0.23,0,0.06,0.19,0.57,0.19,0.02,0.03,0,0.2],
[0,0.1,0,0.36,0.49,0,0.23,0,0.06,0.19,0.57,0.19,0.02,0.03,0,0.2],
[0.16,0.16,0.26,0.15,0,0,0.21,0.32,0,0.46,0.39,0.05,0.16,0,0.33,0.02],
[0,0.11,0,0.18,0.24,0.34,0.69,0.07,0,0.06,0.31,0.26,0.63,0.1,0.4,0.25],
[0,0.11,0,0.18,0.24,0.34,0.69,0.07,0,0.06,0.31,0.26,0.63,0.1,0.4,0.25],
[0.19,0.32,0.34,0.45,0.34,0.58,0.08,0.56,0.02,0.32,0,0.28,0.19,0.48,0.23,0.26],
[0.15,0.07,0.23,0.35,0.2,0.54,0.7,0.42,0,0.06,0,0.01,0.71,0,0,0],
[0.08,0.48,0.22,0.62,0,0,0.39,0.52,0.16,0.03,0.06,0.01,0.34,0.56,0.57,0.2],
[0.08,0.48,0.22,0.62,0,0,0.39,0.52,0.16,0.03,0.06,0.01,0.34,0.56,0.57,0.2],
[0.34,0,0.4,0.08,0.49,0.11,0.1,0.63,0.05,0.33,0.13,0.23,0.49,0.05,0.3,0.53],
[0.05,0.31,0.2,0.61,0.08,0.47,0.5,0.43,0,0.23,0,0.29,0.39,0,0.43,0.14],
[0.05,0.31,0.2,0.61,0.08,0.47,0.5,0.43,0,0.23,0,0.29,0.39,0,0.43,0.14],
[0.21,0.01,0.2,0.12,0.7,0,0.47,0,0,0.51,0.23,0,0.2,0,0,0],
[0,0,0,0.1,0.27,0.6,0,0.37,0,0.43,0.45,0.06,0,0,0.26,0.12],
[0.2,0,0.26,0.14,0.69,0.6,0.5,0.14,0.06,0.2,0.56,0.17,0.24,0,0.27,0.15],
[0.2,0,0.26,0.14,0.69,0.6,0.5,0.14,0.06,0.2,0.56,0.17,0.24,0,0.27,0.15],
[0.17,0.03,0.21,0.2,0.5,0.41,0.46,0,0.17,0.27,0.59,0.25,0.43,0,0.43,0.32],
[0,0,0,0,0.2,0,0.49,0.32,0.19,0.47,0.12,0.23,0.5,0.51,0,0.2],
[0,0,0,0,0.2,0,0.49,0.32,0.19,0.47,0.12,0.23,0.5,0.51,0,0.2],
[0,0,0,0,0.21,0.35,0.56,0.51,0,0.42,0.16,0.35,0.59,0.34,0.09,0.06],
[0,0,0,0.04,0.34,0.11,0.4,0.5,0,0.35,0.14,0.56,0.6,0.55,0.13,0.18],
[0,0,0,0,0.16,0.14,0,0.62,0.26,0.33,0.01,0.41,0.32,0.36,0.47,0],
[0,0,0,0,0.16,0.14,0,0.62,0.26,0.33,0.01,0.41,0.32,0.36,0.47,0],
[0,0.21,0,0.22,0.24,0.43,0.1,0.71,0,0,0.11,0.31,0.47,0.1,0.49,0.6],
[0,0,0,0.3,0.16,0,0.12,0.71,0.2,0.14,0.25,0.09,0.33,0.54,0,0.6],
[0,0,0,0.3,0.16,0,0.12,0.71,0.2,0.14,0.25,0.09,0.33,0.54,0,0.6],
[0,0.46,0.46,0.33,0.24,0.19,0.34,0.61,0.49,0,0,0.21,0.33,0.35,0.5,0.41],
[0.32,0.46,0.62,0.24,0.56,0.59,0,0.47,0.24,0.19,0.06,0.32,0.29,0.2,0.47,0.23],
[0.34,0.48,0,0.07,0.44,0.66,0,0.38,0,0.15,0.38,0.05,0,0.43,0,0.3],
[0.34,0.48,0,0.07,0.44,0.66,0,0.38,0,0.15,0.38,0.05,0,0.43,0,0.3],
[0.13,0.43,0,0,0.23,0.47,0.11,0.41,0,0.42,0.14,0.2,0.42,0.35,0.21,0.25],
[0.24,0.2,0.62,0.6,0.41,0.48,0.48,0.09,0.04,0,0.24,0.09,0.37,0,0,0.33],
[0,0.45,0.64,0.35,0.38,0.45,0.42,0.19,0.04,0,0.35,0.36,0.36,0,0.21,0],
[0,0.45,0.64,0.35,0.38,0.45,0.42,0.19,0.04,0,0.35,0.36,0.36,0,0.21,0],
[0.05,0.6,0.01,0.55,0.09,0.41,0.56,0.24,0.15,0.32,0.41,0.39,0,0.33,0,0.28],
[0.11,0,0.5,0,0.45,0.38,0.23,0.59,0.32,0,0.45,0.6,0.32,0.16,0.12,0.25],
[0.11,0,0.5,0,0.45,0.38,0.23,0.59,0.32,0,0.45,0.6,0.32,0.16,0.12,0.25],
[0.1,0.36,0,0.38,0.27,0.49,0.47,0.46,0.35,0.27,0.1,0.32,0,0.32,0.43,0],
[0.1,0.3,0.38,0,0.63,0.35,0.32,0.6,0.21,0.01,0.13,0.41,0.37,0.26,0,0.41],
[0,0.41,0.2,0.29,0,0.12,0.33,0.53,0.24,0.52,0.49,0.22,0,0.27,0,0.21],
[0,0.41,0.2,0.29,0,0.12,0.33,0.53,0.24,0.52,0.49,0.22,0,0.27,0,0.21],
[0,0,0,0.27,0.11,0.54,0.39,0.44,0,0.33,0.58,0.13,0.51,0.15,0.29,0],
[0.14,0.03,0.28,0.3,0.38,0.44,0,0,0.45,0.57,0.28,0.05,0.27,0.13,0.21,0.27],
[0.14,0.03,0.28,0.3,0.38,0.44,0,0,0.45,0.57,0.28,0.05,0.27,0.13,0.21,0.27],
[0.45,0,0.59,0.28,0.48,0.59,0.39,0.28,0.3,0.3,0.37,0,0.12,0.29,0.35,0.09],
[0.17,0.57,0.03,0.39,0.18,0.5,0.52,0.26,0.12,0.09,0.2,0.44,0,0,0,0.2],
[0.03,0.54,0.56,0.41,0.39,0.07,0.36,0.06,0.38,0,0.5,0.37,0,0.32,0.19,0.17],
[0.03,0.54,0.56,0.41,0.39,0.07,0.36,0.06,0.38,0,0.5,0.37,0,0.32,0.19,0.17],
[0.24,0.05,0,0.24,0,0.12,0.29,0.06,0.19,0.35,0,0.23,0.32,0,0,0],
[0.27,0,0.37,0.12,0.35,0.31,0.4,0.43,0.28,0.16,0.33,0.11,0.25,0,0.43,0.05],
[0.27,0,0.37,0.12,0.35,0.31,0.4,0.43,0.28,0.16,0.33,0.11,0.25,0,0.43,0.05],
[0,0.26,0.57,0.38,0,0.16,0.29,0.27,0.53,0.29,0.23,0.28,0.29,0.37,0.22,0.34],
[0,0.58,0.27,0.04,0.28,0.22,0.32,0.2,0.15,0.21,0.03,0.05,0.31,0,0.25,0],
[0.34,0,0.45,0.37,0.39,0.43,0.2,0.11,0,0.32,0.61,0,0.28,0.25,0.31,0.44],
[0.34,0,0.45,0.37,0.39,0.43,0.2,0.11,0,0.32,0.61,0,0.28,0.25,0.31,0.44],
[0.18,0,0.1,0.53,0.39,0.58,0.3,0.13,0.42,0.47,0.39,0.45,0.4,0,0.02,0.4],
[0,0.37,0,0.38,0.39,0.42,0.57,0.04,0.5,0.3,0.55,0.11,0,0,0.37,0.35],
[0,0.37,0,0.38,0.39,0.42,0.57,0.04,0.5,0.3,0.55,0.11,0,0,0.37,0.35],
[0.42,0.36,0.57,0.29,0.22,0.24,0.42,0.28,0.47,0.3,0.26,0.24,0.46,0,0.09,0.06],
[0.1,0.01,0.39,0.15,0.22,0.35,0.38,0.43,0.38,0.35,0.51,0.34,0,0.13,0.1,0.2],
[0.43,0.03,0.51,0.09,0.17,0.45,0.26,0.01,0.21,0.35,0.03,0.48,0.35,0.33,0,0.03],
[0.43,0.03,0.51,0.09,0.17,0.45,0.26,0.01,0.21,0.35,0.03,0.48,0.35,0.33,0,0.03],
[0.15,0,0,0.46,0,0.48,0,0.31,0.42,0.51,0.28,0.59,0.46,0.16,0.04,0],
[0.28,0.62,0.19,0.32,0.36,0.3,0.03,0.44,0,0,0.41,0.14,0.45,0.36,0.46,0.13],
[0.28,0.62,0.19,0.32,0.36,0.3,0.03,0.44,0,0,0.41,0.14,0.45,0.36,0.46,0.13],
[0.03,0.5,0.48,0.28,0.18,0.43,0.24,0.6,0.29,0,0.07,0,0.15,0,0.16,0.46],
[0.35,0.44,0.36,0,0.43,0.5,0.38,0.61,0.23,0,0,0.16,0.01,0.17,0.29,0],
[0.35,0.44,0.36,0,0.43,0.5,0.38,0.61,0.23,0,0,0.16,0.01,0.17,0.29,0],
[0.31,0.27,0,0.15,0.4,0,0.26,0.35,0.49,0.36,0.5,0,0.35,0.16,0.15,0.43],
[0.14,0.04,0.35,0.02,0.27,0.4,0.13,0.27,0.27,0.6,0.17,0.32,0.13,0.43,0,0.12],
[0.1,0.27,0.26,0,0.22,0.32,0,0.33,0,0.39,0.52,0.32,0.3,0,0.41,0.29],
[0.31,0.13,0.3,0,0.03,0.33,0.54,0,0,0.04,0.64,0.31,0.45,0.02,0.08,0.03],
[0.25,0.02,0.28,0.32,0.22,0.28,0.5,0.39,0.31,0.56,0.42,0.28,0.53,0.17,0.31,0.07],
[0.25,0.02,0.28,0.32,0.22,0.28,0.5,0.39,0.31,0.56,0.42,0.28,0.53,0.17,0.31,0.07],
[0.26,0.05,0.36,0.35,0.42,0,0.56,0.24,0.51,0.41,0,0.28,0.37,0.12,0,0.23],
[0.26,0.12,0.41,0.6,0.22,0.43,0.56,0,0.21,0.11,0,0.31,0.07,0.26,0.24,0],
[0,0,0.06,0,0.53,0.18,0.47,0.35,0.51,0,0.37,0.43,0.29,0,0.38,0.45],
[0.28,0,0.36,0.11,0.13,0.35,0.45,0,0.52,0.06,0,0.41,0.45,0,0.52,0],
[0.28,0,0.36,0.11,0.13,0.35,0.45,0,0.52,0.06,0,0.41,0.45,0,0.52,0],
[0.09,0,0,0.28,0.46,0.32,0.5,0.38,0.49,0.23,0.18,0.27,0.11,0.17,0.48,0.23],
[0,0.28,0.28,0.49,0,0.64,0.3,0.32,0.27,0.44,0.39,0.52,0.15,0.15,0.2,0.01],
[0,0.28,0.28,0.49,0,0.64,0.3,0.32,0.27,0.44,0.39,0.52,0.15,0.15,0.2,0.01],
[0,0.49,0.08,0.54,0.51,0.51,0.55,0.3,0,0.47,0.42,0.06,0.09,0.32,0.24,0.21],
[0.28,0.12,0.66,0,0,0.49,0.36,0,0.41,0.18,0.58,0.12,0,0,0.19,0.36],
[0,0,0,0.31,0.01,0.6,0,0.47,0,0.45,0.13,0.45,0,0.06,0.17,0],
[0,0,0,0.31,0.01,0.6,0,0.47,0,0.45,0.13,0.45,0,0.06,0.17,0],
[0.27,0.26,0.36,0.19,0,0.41,0.31,0.39,0.3,0.15,0.33,0.27,0.01,0,0,0.23],
[0.12,0.02,0.19,0.51,0.07,0.35,0.19,0.23,0.48,0.49,0.37,0,0.41,0.11,0.35,0.09],
[0.12,0.02,0.19,0.51,0.07,0.35,0.19,0.23,0.48,0.49,0.37,0,0.41,0.11,0.35,0.09],
[0.33,0,0.46,0.37,0.41,0.43,0,0.43,0.42,0,0.03,0.18,0.38,0.07,0.24,0.17],
[0.31,0,0.44,0.35,0.28,0.51,0,0.49,0.46,0,0.12,0.22,0,0.36,0.44,0.53],
[0,0,0,0.44,0.6,0.41,0.28,0.24,0.2,0.21,0.27,0.34,0,0.18,0.56,0.26],
[0,0,0,0.44,0.6,0.41,0.28,0.24,0.2,0.21,0.27,0.34,0,0.18,0.56,0.26],
[0.09,0.29,0.31,0.39,0.45,0,0,0.08,0,0,0,0.45,0.15,0.32,0.6,0.39],
[0,0.18,0,0.31,0.46,0.38,0,0.4,0.04,0.43,0.51,0.35,0.11,0,0.1,0],
[0,0.18,0,0.31,0.46,0.38,0,0.4,0.04,0.43,0.51,0.35,0.11,0,0.1,0],
[0.19,0.1,0.06,0.04,0.67,0,0.41,0.4,0.19,0.4,0.27,0.12,0,0.03,0.09,0.08],
[0.2,0.14,0.19,0.29,0.37,0.66,0.2,0,0.21,0,0,0.05,0,0,0,0.07],
[0.26,0.24,0.06,0.53,0.37,0,0.72,0.26,0,0,0.17,0.15,0.24,0,0.25,0],
[0.26,0.24,0.06,0.53,0.37,0,0.72,0.26,0,0,0.17,0.15,0.24,0,0.25,0],
[0.52,0.15,0.64,0.55,0,0.6,0.66,0.19,0.43,0.19,0,0,0.47,0,0,0.31],
[0.38,0,0.56,0.65,0.39,0.55,0.49,0.04,0,0.32,0.2,0.22,0.45,0.07,0.34,0],
[0.38,0,0.56,0.65,0.39,0.55,0.49,0.04,0,0.32,0.2,0.22,0.45,0.07,0.34,0],
[0.34,0.04,0.53,0.63,0,0.52,0.46,0.43,0,0.29,0.21,0.29,0.41,0.31,0.25,0.21],
[0.08,0,0.21,0.39,0.4,0.38,0.36,0.32,0.24,0.17,0,0.19,0.4,0.06,0.57,0],
[0.08,0,0.21,0.39,0.4,0.38,0.36,0.32,0.24,0.17,0,0.19,0.4,0.06,0.57,0],
[0,0.29,0.09,0.55,0,0.44,0,0.19,0.51,0.09,0.47,0.3,0.14,0.2,0.44,0.31],
[0,0,0,0,0.38,0.21,0.27,0.2,0.23,0.23,0.27,0.24,0,0.32,0.31,0.53],
[0.18,0,0.23,0.34,0.55,0.55,0.09,0.1,0,0.55,0.3,0.2,0.03,0,0.23,0.4],
[0.42,0,0.47,0.1,0.74,0.34,0.48,0,0,0,0.52,0.08,0.1,0,0.01,0.23],
[0.42,0,0.47,0.1,0.74,0.34,0.48,0,0,0,0.52,0.08,0.1,0,0.01,0.23],
[0,0.04,0,0,0,0.74,0,0.03,0,0.29,0,0.36,0.22,0.17,0.42,0],
[0.13,0.1,0.24,0.24,0.5,0.46,0.64,0.48,0,0.32,0,0.64,0.2,0.12,0.2,0.15],
[0.13,0.1,0.24,0.24,0.5,0.46,0.64,0.48,0,0.32,0,0.64,0.2,0.12,0.2,0.15],
[0.05,0.35,0,0.45,0.24,0.73,0.22,0.41,0,0.1,0.24,0.33,0.4,0.25,0,0],
[0.22,0.27,0.12,0.37,0.42,0.68,0.05,0.39,0.22,0.19,0.53,0.35,0.66,0,0.06,0],
[0.18,0,0.32,0,0,0.41,0.4,0.48,0.36,0.07,0.3,0.41,0.67,0.02,0.41,0.36],
[0.18,0,0.32,0,0,0.41,0.4,0.48,0.36,0.07,0.3,0.41,0.67,0.02,0.41,0.36],
[0.3,0,0.42,0,0.31,0.34,0,0.51,0.37,0.1,0,0.43,0.42,0.42,0,0.56],
[0.18,0,0.25,0.3,0.38,0.34,0.23,0.46,0.32,0.3,0.13,0.49,0.13,0.38,0.44,0.56],
[0.18,0,0.25,0.3,0.38,0.34,0.23,0.46,0.32,0.3,0.13,0.49,0.13,0.38,0.44,0.56],
[0.26,0.17,0.36,0.4,0.44,0.11,0.23,0.49,0.31,0.14,0.4,0.11,0.36,0.05,0.37,0],
[0,0.36,0,0.42,0.04,0.41,0.17,0.34,0,0.12,0,0.32,0.1,0.36,0.23,0.55],
[0.19,0.06,0.32,0,0.51,0.13,0.33,0.31,0.18,0.12,0.43,0.28,0,0.19,0.55,0.09],
[0.19,0.06,0.32,0,0.51,0.13,0.33,0.31,0.18,0.12,0.43,0.28,0,0.19,0.55,0.09],
[0,0.07,0,0.14,0.4,0.48,0.2,0.04,0,0.43,0.64,0,0.16,0,0.56,0.5],
[0.05,0,0,0,0.37,0,0,0.34,0.32,0.43,0.31,0.39,0.64,0.4,0.27,0.18],
[0.05,0,0,0,0.37,0,0,0.34,0.32,0.43,0.31,0.39,0.64,0.4,0.27,0.18],
[0,0,0,0,0.05,0.3,0.35,0.1,0,0.25,0,0.56,0.46,0,0.28,0.1],
[0,0.2,0,0.2,0.37,0.29,0.52,0.01,0,0.13,0.25,0.55,0.43,0.26,0.12,0.26],
[0.09,0.15,0.17,0.21,0,0.38,0.53,0.36,0.51,0.35,0.48,0.4,0.51,0.38,0.24,0.46],
[0.09,0.15,0.17,0.21,0,0.38,0.53,0.36,0.51,0.35,0.48,0.4,0.51,0.38,0.24,0.46],
[0,0,0,0,0.21,0.3,0,0.49,0.39,0.22,0.36,0.27,0.49,0.08,0.13,0.35],
[0.01,0,0.1,0,0.25,0,0.28,0.45,0.19,0,0,0.44,0.1,0.3,0.49,0],
[0.01,0,0.1,0,0.25,0,0.28,0.45,0.19,0,0,0.44,0.1,0.3,0.49,0],
[0.02,0,0,0,0,0.26,0.1,0.29,0.25,0,0,0.2,0.33,0.11,0.59,0.28],
[0.57,0,0.25,0.18,0.22,0.36,0.35,0.1,0.24,0,0.44,0.39,0.33,0.12,0.47,0.2],
[0,0.61,0.27,0.54,0.58,0.29,0,0.33,0.29,0,0.19,0,0.47,0,0.3,0],
[0,0.61,0.27,0.54,0.58,0.29,0,0.33,0.29,0,0.19,0,0.47,0,0.3,0],
[0.5,0.39,0.27,0.62,0.36,0,0.36,0.04,0.16,0,0,0.31,0.15,0.43,0.17,0.09],
[0,0.2,0.55,0.56,0,0.38,0,0.36,0.17,0.07,0.04,0.29,0.03,0,0.29,0.1],
[0,0.38,0.47,0,0.44,0.1,0.08,0,0.38,0.06,0.26,0.29,0.28,0.27,0.42,0.32],
[0,0.47,0,0.48,0.24,0,0.3,0.06,0.24,0.19,0.05,0.28,0.09,0,0.22,0.38],
[0,0.47,0,0.48,0.24,0,0.3,0.06,0.24,0.19,0.05,0.28,0.09,0,0.22,0.38],
[0.15,0.4,0.46,0.18,0.54,0,0.42,0.51,0.19,0.46,0.36,0.42,0.14,0.33,0,0.14],
[0,0.17,0.59,0,0.32,0.43,0.42,0.22,0.55,0.03,0.25,0,0.54,0.24,0.02,0],
[0.1,0.45,0.54,0.2,0,0,0,0,0.48,0.07,0.32,0.11,0.51,0.28,0.28,0.21],
[0.01,0.49,0.4,0.46,0.12,0.21,0.46,0.4,0.28,0.24,0,0.24,0.18,0.26,0.33,0.32],
[0.01,0.49,0.4,0.46,0.12,0.21,0.46,0.4,0.28,0.24,0,0.24,0.18,0.26,0.33,0.32],
[0.45,0,0.63,0.36,0,0,0.4,0.3,0.27,0.11,0.35,0.44,0.39,0,0.4,0.24],
[0.36,0.32,0.53,0.48,0.09,0.38,0.46,0.17,0.46,0.16,0.47,0.49,0.43,0,0,0.36],
[0.16,0.34,0.1,0.7,0.45,0.49,0.44,0.29,0,0.29,0,0.64,0.25,0.07,0.2,0.01],
[0.16,0.34,0.1,0.7,0.45,0.49,0.44,0.29,0,0.29,0,0.64,0.25,0.07,0.2,0.01],
[0.2,0.51,0.18,0,0.04,0.26,0.21,0.48,0.16,0.28,0,0.4,0.06,0,0,0.49],
[0.2,0.51,0.18,0,0.04,0.26,0.21,0.48,0.16,0.28,0,0.4,0.06,0,0,0.49],
[0.14,0.51,0.31,0.44,0.44,0.15,0.38,0.32,0.6,0.12,0.36,0.26,0.24,0.11,0.36,0.22],
[0.14,0.51,0.31,0.44,0.44,0.15,0.38,0.32,0.6,0.12,0.36,0.26,0.24,0.11,0.36,0.22],
[0,0.58,0,0.19,0.5,0,0.14,0.39,0.1,0.36,0.17,0.33,0.24,0.29,0.22,0.35],
[0,0.6,0.52,0.39,0,0.4,0.13,0.22,0.37,0.35,0.24,0.37,0.53,0.42,0.05,0.29],
[0.24,0.45,0.35,0.39,0.41,0.67,0,0,0.38,0.31,0.56,0.45,0.27,0.05,0.12,0],
[0.15,0.36,0.3,0.57,0.25,0.53,0.44,0.02,0.32,0.15,0.4,0.64,0,0.35,0.35,0.4],
[0.15,0.36,0.3,0.57,0.25,0.53,0.44,0.02,0.32,0.15,0.4,0.64,0,0.35,0.35,0.4],
[0.35,0.14,0.51,0.66,0.12,0.57,0.49,0.01,0,0.27,0.39,0.6,0.12,0.04,0.11,0.11],
[0.35,0.14,0.51,0.66,0.12,0.57,0.49,0.01,0,0.27,0.39,0.6,0.12,0.04,0.11,0.11],
[0,0,0.08,0.39,0.59,0.27,0.04,0.22,0.42,0.11,0.28,0.01,0.21,0.13,0.34,0.21],
[0.19,0.39,0.35,0.59,0,0.05,0.58,0.31,0.39,0,0,0.19,0.08,0,0.16,0.03],
[0.19,0.39,0.35,0.59,0,0.05,0.58,0.31,0.39,0,0,0.19,0.08,0,0.16,0.03],
[0.45,0.22,0.46,0.08,0.54,0.03,0.38,0.27,0.61,0,0,0.06,0.35,0.08,0.38,0.25],
[0.14,0.42,0.47,0.62,0.51,0.15,0,0.49,0.55,0.32,0.01,0.22,0.32,0.44,0.35,0.19],
[0.14,0.42,0.47,0.62,0.51,0.15,0,0.49,0.55,0.32,0.01,0.22,0.32,0.44,0.35,0.19],
[0.08,0,0.65,0,0.47,0.38,0.45,0.36,0.31,0.08,0,0.37,0.2,0,0.31,0.27],
[0.09,0,0.64,0.06,0.48,0.54,0,0.47,0.49,0,0.07,0.22,0,0.22,0.18,0],
[0.06,0.45,0.37,0.24,0.3,0.47,0.29,0.34,0.04,0.08,0.24,0.36,0,0,0.15,0.19],
[0.06,0.45,0.37,0.24,0.3,0.47,0.29,0.34,0.04,0.08,0.24,0.36,0,0,0.15,0.19],
[0.3,0,0.57,0.49,0.01,0,0,0.54,0.43,0.41,0.55,0.37,0.36,0.03,0.24,0.11],
[0.24,0,0.27,0.28,0.29,0.33,0.15,0.23,0.56,0,0.48,0.42,0.32,0.39,0.3,0.06],
[0,0,0.27,0.25,0.13,0.38,0.11,0.21,0.33,0.27,0.19,0.47,0.19,0.08,0.2,0.37],
[0,0,0.27,0.25,0.13,0.38,0.11,0.21,0.33,0.27,0.19,0.47,0.19,0.08,0.2,0.37],
[0.29,0.48,0.48,0.65,0.43,0.19,0.54,0.45,0.56,0,0.25,0.18,0.03,0.11,0.45,0.23],
[0.28,0.29,0.39,0,0.61,0.28,0.28,0.35,0.64,0,0.52,0.42,0,0.12,0.46,0],
[0.28,0.29,0.39,0,0.61,0.28,0.28,0.35,0.64,0,0.52,0.42,0,0.12,0.46,0],
[0.3,0.21,0.42,0.58,0.35,0.38,0,0.42,0.05,0.1,0.31,0.41,0.24,0.23,0.27,0.36],
[0,0.16,0,0.33,0.43,0.1,0.02,0.27,0.24,0.4,0.05,0,0,0,0,0.45],
[0,0.02,0,0,0.34,0,0.1,0.4,0.58,0.24,0.04,0.44,0,0.25,0.32,0.18],
[0,0.02,0,0,0.34,0,0.1,0.4,0.58,0.24,0.04,0.44,0,0.25,0.32,0.18],
[0.07,0.37,0.02,0.45,0.21,0.14,0.02,0.39,0,0.44,0.08,0.42,0.39,0.05,0.17,0],
[0.12,0.09,0.49,0.71,0.45,0.34,0.21,0.1,0.22,0.36,0.4,0.6,0.43,0.24,0,0],
[0.12,0.09,0.49,0.71,0.45,0.34,0.21,0.1,0.22,0.36,0.4,0.6,0.43,0.24,0,0],
[0.01,0.13,0.43,0.57,0.26,0.51,0,0,0.56,0.07,0.39,0.08,0.3,0.35,0,0],
[0,0.47,0.09,0.68,0.12,0,0.39,0.24,0.28,0.43,0.38,0.18,0.02,0,0.29,0.39],
[0,0.47,0.09,0.68,0.12,0,0.39,0.24,0.28,0.43,0.38,0.18,0.02,0,0.29,0.39],
[0.03,0.31,0.08,0.59,0.24,0.18,0.2,0.29,0.48,0.04,0.16,0.47,0.43,0.18,0.44,0.42],
[0.29,0,0.37,0.47,0.4,0.3,0.29,0.54,0.39,0.43,0.22,0,0.23,0.24,0.08,0.26],
[0.29,0,0.37,0.47,0.4,0.3,0.29,0.54,0.39,0.43,0.22,0,0.23,0.24,0.08,0.26],
[0.36,0.25,0.46,0.42,0.36,0.2,0.27,0.39,0.03,0.04,0.19,0.37,0.12,0,0,0.4],
[0,0,0,0,0.4,0.35,0.01,0.43,0.25,0.44,0.33,0.23,0.21,0.11,0.12,0.46],
[0,0,0,0.07,0.28,0,0,0,0.54,0.22,0.37,0,0,0.32,0.17,0],
[0,0,0,0.07,0.28,0,0,0,0.54,0.22,0.37,0,0,0.32,0.17,0],
[0,0.01,0.03,0.15,0.13,0.45,0,0.52,0,0.1,0.23,0.04,0.44,0.31,0.11,0.01],
[0.01,0,0.06,0,0.6,0.05,0.45,0.06,0,0.05,0.31,0.18,0.52,0.17,0.24,0.21],
[0.01,0,0.06,0,0.6,0.05,0.45,0.06,0,0.05,0.31,0.18,0.52,0.17,0.24,0.21],
[0,0,0.01,0.08,0.31,0.51,0.45,0.18,0.27,0.3,0.33,0,0.05,0,0,0.03],
[0.11,0,0.03,0.11,0.11,0.37,0.3,0.19,0.23,0.18,0.39,0.43,0.23,0,0.11,0.12],
[0.1,0,0.12,0.26,0,0.19,0.06,0.15,0,0.08,0,0.62,0,0,0,0],
[0,0.37,0.07,0.62,0,0,0.44,0.22,0.51,0.15,0.33,0.41,0,0.09,0.02,0.41],
[0,0.37,0.07,0.62,0,0,0.44,0.22,0.51,0.15,0.33,0.41,0,0.09,0.02,0.41],
[0.07,0,0.02,0.24,0.48,0,0.48,0.56,0.6,0.24,0.5,0.49,0,0,0.52,0.15],
[0.07,0,0.02,0.24,0.48,0,0.48,0.56,0.6,0.24,0.5,0.49,0,0,0.52,0.15],
[0.01,0.25,0,0.48,0.34,0.36,0.15,0.62,0.54,0,0.43,0.04,0.07,0.08,0.29,0.37],
[0,0.49,0,0.64,0.44,0.61,0.34,0.43,0,0.47,0.01,0.54,0.37,0.1,0.07,0.56],
[0.09,0.32,0.13,0.54,0.67,0.4,0,0.35,0.49,0,0.38,0.31,0,0.18,0.34,0.43],
[0.09,0.32,0.13,0.54,0.67,0.4,0,0.35,0.49,0,0.38,0.31,0,0.18,0.34,0.43],
[0,0.4,0,0.57,0.54,0.17,0,0.45,0,0.3,0.31,0.07,0,0.4,0,0.18],
[0,0.26,0,0.42,0.24,0.11,0.46,0.33,0.26,0.35,0.56,0.23,0.39,0.38,0.28,0.49],
[0,0.26,0,0.42,0.24,0.11,0.46,0.33,0.26,0.35,0.56,0.23,0.39,0.38,0.28,0.49],
[0.08,0.14,0.19,0.18,0.39,0.64,0.38,0,0.41,0.15,0.31,0.53,0.24,0.13,0,0.31],
[0.15,0,0.19,0,0.32,0.58,0,0.16,0.33,0,0.22,0.36,0.31,0,0.14,0.19],
[0.1,0,0.06,0,0.21,0,0.44,0,0.14,0.06,0.14,0.47,0.11,0,0,0.17],
[0.15,0.11,0.21,0.08,0.37,0.1,0.2,0.18,0.21,0,0.23,0.02,0,0,0.57,0.5],
[0.15,0.11,0.21,0.08,0.37,0.1,0.2,0.18,0.21,0,0.23,0.02,0,0,0.57,0.5],
[0,0,0,0,0.08,0.42,0.48,0.01,0.46,0,0,0,0.28,0,0.46,0.54],
[0.13,0.08,0.23,0.28,0.43,0,0.51,0.36,0.52,0,0,0.35,0.21,0.36,0,0.48],
[0,0.3,0.17,0.52,0.61,0.47,0.39,0.05,0.45,0.35,0.05,0.32,0,0.2,0,0.43],
[0,0.3,0.17,0.52,0.61,0.47,0.39,0.05,0.45,0.35,0.05,0.32,0,0.2,0,0.43],
[0,0,0,0.15,0.65,0.32,0.26,0.53,0,0.13,0,0.36,0,0,0,0.25],
[0,0.25,0,0.4,0.22,0.05,0.43,0.26,0.2,0,0.22,0.37,0.27,0,0.17,0.18],
[0.07,0,0.11,0,0,0.45,0.32,0,0,0,0.46,0.03,0.4,0,0.25,0.16],
[0.07,0,0.11,0,0,0.45,0.32,0,0,0,0.46,0.03,0.4,0,0.25,0.16],
[0,0,0,0,0,0.48,0.35,0.09,0.29,0.16,0.02,0,0,0,0,0.04],
[0,0,0,0,0,0.48,0.35,0.09,0.29,0.16,0.02,0,0,0,0,0.04],
[0,0.07,0,0.2,0,0,0.17,0.7,0,0.33,0.11,0,0.35,0,0.61,0.35],
[0,0.07,0,0.2,0,0,0.17,0.7,0,0.33,0.11,0,0.35,0,0.61,0.35],
[0,0,0,0.15,0.08,0,0.19,0.73,0,0.32,0.02,0.31,0,0.08,0.42,0.34],
[0,0,0,0,0.19,0,0.25,0.59,0,0.28,0.18,0.07,0,0.4,0.16,0.5],
[0,0,0,0,0.19,0,0.25,0.59,0,0.28,0.18,0.07,0,0.4,0.16,0.5],
[0,0.21,0,0.27,0.12,0.36,0.19,0.31,0.25,0,0.07,0.31,0,0.3,0.26,0.34],
[0,0,0.1,0,0.25,0.06,0,0.23,0.43,0,0,0.2,0.16,0.14,0.25,0.34],
[0,0,0.1,0,0.25,0.06,0,0.23,0.43,0,0,0.2,0.16,0.14,0.25,0.34],
[0,0.08,0.17,0.38,0.09,0.31,0.57,0.3,0.32,0.35,0.31,0,0.33,0.34,0,0.21],
[0,0.08,0.17,0.38,0.09,0.31,0.57,0.3,0.32,0.35,0.31,0,0.33,0.34,0,0.21],
[0.51,0.38,0,0,0,0,0.55,0.34,0.45,0.31,0.15,0,0.2,0.24,0.24,0.17],
[0.51,0.38,0,0,0,0,0.55,0.34,0.45,0.31,0.15,0,0.2,0.24,0.24,0.17],
[0,0.55,0.54,0.54,0.19,0.22,0.32,0.57,0.39,0.44,0.33,0,0.14,0.42,0.28,0.01],
[0,0.55,0.16,0,0.43,0.58,0.46,0.44,0.17,0.12,0,0.17,0.38,0.26,0,0.17],
[0.29,0,0,0.32,0.56,0,0,0.15,0.55,0,0.3,0.37,0.35,0,0.13,0.17],
[0.01,0.25,0.41,0.02,0.3,0.56,0,0,0.38,0.34,0.13,0.25,0.23,0,0,0.07],
[0,0.48,0,0.02,0.51,0,0.12,0.36,0.01,0.34,0,0.14,0.2,0,0.39,0.52],
[0,0.48,0,0.02,0.51,0,0.12,0.36,0.01,0.34,0,0.14,0.2,0,0.39,0.52],
[0.41,0,0.54,0.39,0.05,0.17,0.66,0.24,0,0.2,0.48,0.48,0.36,0.12,0.21,0.16],
[0.01,0.29,0.4,0.57,0.44,0.49,0.12,0.23,0,0.27,0.57,0.4,0.31,0.32,0.08,0.43],
[0.01,0.29,0.4,0.57,0.44,0.49,0.12,0.23,0,0.27,0.57,0.4,0.31,0.32,0.08,0.43],
[0.14,0.36,0.3,0.66,0.23,0.39,0.06,0.38,0,0.34,0,0.43,0.25,0,0.34,0.47],
[0.27,0.33,0.14,0.73,0.25,0.18,0.43,0.41,0.02,0,0,0.24,0.45,0.2,0.46,0],
[0.18,0,0.28,0.63,0.39,0.4,0.23,0.64,0.21,0.15,0.3,0.21,0.17,0.55,0.09,0.37],
[0,0.27,0.02,0.69,0.38,0,0.4,0.51,0.13,0.23,0.5,0,0.58,0.5,0.52,0.26],
[0,0.27,0.02,0.69,0.38,0,0.4,0.51,0.13,0.23,0.5,0,0.58,0.5,0.52,0.26],
[0,0.59,0.3,0.54,0.61,0.55,0.44,0.37,0.18,0.35,0.04,0.16,0.09,0,0.36,0.11],
[0,0.59,0.3,0.54,0.61,0.55,0.44,0.37,0.18,0.35,0.04,0.16,0.09,0,0.36,0.11],
[0,0.28,0.61,0.31,0.73,0,0.45,0.47,0.22,0.35,0.23,0,0,0,0.08,0.2],
[0,0.59,0.45,0.05,0.53,0.65,0.45,0.51,0.37,0.09,0,0,0.1,0.18,0,0],
[0,0.59,0.45,0.05,0.53,0.65,0.45,0.51,0.37,0.09,0,0,0.1,0.18,0,0],
[0.31,0.04,0.35,0,0,0.41,0,0,0.41,0.25,0.41,0.56,0,0,0.05,0.21],
[0.07,0.16,0.38,0.26,0,0.44,0.44,0.31,0.03,0.32,0.44,0.47,0.22,0.44,0.08,0.08],
[0.21,0,0.47,0,0.28,0.36,0,0.36,0.06,0.2,0.39,0.24,0.38,0.31,0,0],
[0.33,0.35,0.44,0.47,0.29,0,0.29,0.32,0.21,0.29,0.46,0.2,0,0.55,0,0],
[0.4,0.2,0.54,0.61,0.49,0.35,0.12,0.03,0,0,0.25,0.24,0.59,0.39,0.37,0.19],
[0.1,0.18,0.34,0.72,0.42,0,0.26,0,0,0,0.13,0.33,0.39,0.69,0.15,0.3],
[0.1,0.18,0.34,0.72,0.42,0,0.26,0,0,0,0.13,0.33,0.39,0.69,0.15,0.3],
[0,0,0.3,0.65,0.58,0,0.33,0.21,0.51,0.09,0.02,0,0.52,0.15,0.53,0],
[0,0,0.15,0,0.54,0,0,0.4,0.21,0.46,0.23,0.02,0,0.51,0.33,0],
[0.27,0.27,0.33,0.02,0.03,0.43,0.48,0.39,0.45,0.44,0,0.39,0.49,0.31,0.43,0.22],
[0.16,0.3,0.32,0.34,0.3,0.56,0.44,0,0.5,0.41,0.09,0.25,0,0.34,0.05,0],
[0.16,0.3,0.32,0.34,0.3,0.56,0.44,0,0.5,0.41,0.09,0.25,0,0.34,0.05,0],
[0.34,0,0.62,0,0.59,0.45,0.45,0.43,0.48,0.01,0.5,0.53,0.29,0.33,0.08,0],
[0.34,0.28,0.55,0.22,0.61,0.19,0.21,0.3,0.44,0.26,0.13,0.56,0.21,0.11,0.2,0.12],
[0.52,0.06,0.68,0.58,0.31,0.53,0.24,0.24,0,0.41,0,0.22,0.04,0.05,0.44,0],
[0.52,0.06,0.68,0.58,0.31,0.53,0.24,0.24,0,0.41,0,0.22,0.04,0.05,0.44,0],
[0.17,0,0.38,0,0.55,0.42,0.57,0.5,0,0,0.24,0.39,0.53,0.51,0.45,0],
[0.29,0.39,0.41,0.48,0.27,0.36,0.14,0.59,0,0.2,0,0.45,0.4,0.62,0,0],
[0.29,0.39,0.41,0.48,0.27,0.36,0.14,0.59,0,0.2,0,0.45,0.4,0.62,0,0],
[0.34,0.19,0.41,0.36,0.42,0,0.39,0.42,0.03,0.35,0,0.25,0.35,0.08,0.5,0.27],
[0.42,0.03,0.51,0.19,0.42,0.09,0.21,0.32,0.44,0.07,0.35,0.5,0.23,0.41,0,0.03],
[0.06,0.23,0.16,0.41,0,0.51,0.43,0.21,0.53,0.3,0.39,0.24,0.3,0.53,0.3,0.09],
[0.16,0.18,0.28,0.43,0.09,0.3,0.08,0.29,0.23,0.59,0.41,0.32,0.55,0.21,0.45,0],
[0,0,0,0.31,0.26,0.09,0.37,0,0.41,0,0,0,0,0.42,0.31,0],
[0,0,0,0,0.18,0,0.47,0,0.27,0.39,0.32,0.11,0,0,0,0.2],
[0.2,0.1,0.18,0.39,0.44,0.25,0.37,0.05,0.3,0.17,0.49,0.07,0.4,0,0,0],
[0,0.12,0.14,0,0.21,0.45,0.46,0.02,0.4,0,0.51,0.52,0.19,0,0.16,0.17],
[0.27,0.27,0.37,0,0.47,0.04,0.2,0.58,0.25,0.37,0,0.36,0.6,0.08,0.5,0],
[0.47,0,0.61,0,0.62,0.23,0.52,0.41,0.21,0.27,0.03,0.16,0,0.57,0,0.31],
[0.56,0.04,0.68,0.59,0.51,0.04,0.38,0.26,0.29,0,0.17,0.13,0.58,0,0.56,0],
[0.56,0.04,0.68,0.59,0.51,0.04,0.38,0.26,0.29,0,0.17,0.13,0.58,0,0.56,0],
[0.28,0.21,0.29,0.42,0,0.42,0,0.08,0.36,0.64,0.06,0.03,0.33,0.69,0,0],
[0.28,0.21,0.29,0.42,0,0.42,0,0.08,0.36,0.64,0.06,0.03,0.33,0.69,0,0],
[0,0.1,0,0.36,0.41,0,0.31,0.02,0,0.54,0.12,0.36,0.14,0.39,0.11,0],
[0,0.1,0,0.36,0.41,0,0.31,0.02,0,0.54,0.12,0.36,0.14,0.39,0.11,0],
[0.18,0.02,0.26,0.16,0.46,0,0.21,0,0.53,0.37,0.25,0,0.18,0,0.23,0],
[0.16,0,0.19,0.02,0,0.21,0.44,0.1,0.43,0,0.22,0.59,0.21,0.28,0.14,0.27],
[0.16,0,0.19,0.02,0,0.21,0.44,0.1,0.43,0,0.22,0.59,0.21,0.28,0.14,0.27],
[0.12,0.26,0.16,0.36,0.34,0.5,0.41,0.25,0.33,0.22,0,0.3,0.22,0.03,0.11,0],
[0,0.12,0,0.3,0.01,0.6,0.39,0.01,0.26,0.14,0.23,0.21,0,0.22,0,0],
[0,0.12,0,0.3,0.01,0.6,0.39,0.01,0.26,0.14,0.23,0.21,0,0.22,0,0],
[0.25,0.19,0.31,0.31,0.09,0.24,0.65,0.57,0,0,0.23,0.25,0.29,0.16,0.46,0],
[0,0.08,0,0.15,0.33,0.43,0.53,0.62,0.23,0,0.34,0,0.32,0.22,0.23,0],
[0,0.35,0.03,0.35,0,0.36,0.17,0.63,0,0.09,0.16,0.22,0.27,0.46,0.22,0],
[0,0.35,0.03,0.35,0,0.36,0.17,0.63,0,0.09,0.16,0.22,0.27,0.46,0.22,0],
[0.23,0,0.17,0.08,0.28,0.29,0.59,0.33,0.61,0,0.32,0.25,0.42,0.47,0.33,0],
[0.17,0.19,0.24,0.29,0.53,0,0.07,0.09,0.12,0.63,0.45,0,0.11,0.44,0,0],
[0,0.06,0,0.3,0.38,0.33,0,0.18,0.5,0.39,0.4,0.24,0.08,0.35,0.33,0],
[0,0.06,0,0.3,0.38,0.33,0,0.18,0.5,0.39,0.4,0.24,0.08,0.35,0.33,0],
[0,0,0,0.1,0,0,0.08,0.39,0.43,0.49,0.09,0.19,0.14,0.25,0,0],
[0.42,0,0.44,0.2,0.56,0.04,0.61,0.02,0.05,0,0.44,0.46,0.19,0,0.41,0],
[0.42,0,0.44,0.2,0.56,0.04,0.61,0.02,0.05,0,0.44,0.46,0.19,0,0.41,0],
[0.24,0,0.27,0,0.46,0.65,0.55,0,0.1,0.07,0,0.36,0.21,0.36,0.1,0.21],
[0,0.12,0.04,0.26,0.26,0.5,0,0.03,0,0.31,0,0.23,0.02,0,0,0.28],
[0,0.12,0.04,0.26,0.26,0.5,0,0.03,0,0.31,0,0.23,0.02,0,0,0.28],
[0,0.3,0,0.31,0,0.43,0.4,0.68,0.23,0.22,0,0.34,0,0.31,0.16,0.01],
[0.16,0.25,0.14,0.35,0.29,0.57,0.39,0.73,0.15,0.27,0.13,0.27,0,0.61,0.25,0.26],
[0.3,0.01,0.3,0,0.27,0.37,0.7,0.48,0,0.17,0,0.11,0.48,0.22,0.42,0],
[0.3,0.01,0.3,0,0.27,0.37,0.7,0.48,0,0.17,0,0.11,0.48,0.22,0.42,0],
[0.11,0,0.09,0,0.2,0,0.21,0.35,0,0.02,0.23,0.13,0.33,0.27,0.39,0.01],
[0.09,0,0.11,0,0,0.26,0.08,0.3,0.51,0.56,0.33,0,0,0.49,0.08,0.04],
[0.03,0,0.09,0,0.05,0.47,0.3,0.3,0,0.18,0.05,0,0.47,0.44,0.02,0.19],
[0,0.21,0,0.18,0.29,0.72,0.45,0,0.24,0.2,0.31,0.5,0.28,0,0.07,0.14],
[0,0.21,0,0.18,0.29,0.72,0.45,0,0.24,0.2,0.31,0.5,0.28,0,0.07,0.14],
[0.17,0.27,0.23,0.4,0.43,0.7,0.48,0.1,0,0.21,0.29,0.34,0,0,0.08,0.18],
[0.27,0.04,0.33,0.2,0.55,0.39,0.69,0,0.29,0,0.26,0.19,0.27,0,0.2,0.14],
[0.18,0.01,0.19,0,0.38,0.44,0.66,0.33,0.49,0,0.35,0.12,0,0.54,0.03,0.04],
[0.18,0.01,0.19,0,0.38,0.44,0.66,0.33,0.49,0,0.35,0.12,0,0.54,0.03,0.04],
[0.29,0,0.3,0,0.43,0.21,0.67,0.27,0.3,0.23,0.36,0.3,0.14,0.5,0,0.08],
[0,0.08,0,0.12,0,0.33,0.64,0.57,0.29,0,0.23,0,0.56,0,0.18,0],
[0,0.08,0,0.12,0,0.33,0.64,0.57,0.29,0,0.23,0,0.56,0,0.18,0],
[0,0.09,0,0.15,0,0.38,0.36,0.33,0.44,0.61,0.26,0.16,0.1,0.41,0.24,0],
[0.28,0,0.27,0,0.32,0,0,0.26,0.56,0.13,0,0,0.42,0.19,0.04,0],
[0.03,0,0.09,0,0.15,0.05,0.31,0.02,0.26,0.18,0,0,0,0.36,0,0],
[0.03,0,0.09,0,0.15,0.05,0.31,0.02,0.26,0.18,0,0,0,0.36,0,0],
[0,0.14,0,0.17,0.04,0.04,0.18,0,0.38,0.32,0.21,0.38,0.5,0.11,0,0],
[0.1,0,0.05,0,0,0.01,0.05,0,0.23,0.36,0.32,0.25,0.11,0,0,0],
[0.1,0,0.05,0,0,0.01,0.05,0,0.23,0.36,0.32,0.25,0.11,0,0,0],
[0,0,0,0,0,0.36,0.37,0.21,0.18,0.11,0.46,0.6,0.35,0,0,0],
[0.54,0.22,0.39,0.27,0.29,0,0.57,0.39,0,0.46,0.44,0.37,0.02,0.44,0.12,0.4],
[0.37,0.52,0.5,0.41,0.29,0.01,0.59,0.21,0.07,0.31,0.22,0.41,0.3,0,0,0.22],
[0.37,0.52,0.5,0.41,0.29,0.01,0.59,0.21,0.07,0.31,0.22,0.41,0.3,0,0,0.22],
[0.06,0.67,0.53,0.38,0.25,0.21,0.41,0.54,0,0.01,0.17,0.45,0.5,0.45,0,0.22],
[0.06,0.67,0.53,0.38,0.25,0.21,0.41,0.54,0,0.01,0.17,0.45,0.5,0.45,0,0.22],
[0.2,0.36,0.34,0.59,0.2,0.41,0.23,0.29,0.31,0.41,0.19,0.02,0,0.32,0.44,0.12],
[0.25,0,0,0.41,0.6,0.46,0.38,0.04,0.17,0,0.33,0.08,0.52,0.08,0.16,0.51],
[0,0.15,0.11,0.66,0.57,0.54,0.48,0.21,0,0.31,0,0,0.25,0.11,0.08,0.18],
[0,0.15,0.11,0.66,0.57,0.54,0.48,0.21,0,0.31,0,0,0.25,0.11,0.08,0.18],
[0.14,0.14,0.09,0.55,0.04,0.14,0.14,0.02,0.38,0.42,0.44,0.13,0.3,0.26,0.33,0.23],
[0.17,0.54,0,0.6,0.47,0.4,0.51,0.5,0.42,0.35,0.37,0.36,0.16,0.07,0.38,0.03],
[0.4,0.41,0.63,0.42,0,0.64,0,0.55,0.11,0.52,0.2,0.33,0.18,0.1,0,0],
[0.4,0.41,0.63,0.42,0,0.64,0,0.55,0.11,0.52,0.2,0.33,0.18,0.1,0,0],
[0.13,0.19,0,0.17,0,0,0.5,0.3,0,0.42,0.26,0.55,0.52,0.44,0,0],
[0.05,0,0.12,0.47,0.18,0,0.55,0.27,0,0.39,0.5,0.44,0.49,0.41,0,0.23],
[0.45,0.32,0.6,0.35,0.39,0.14,0.44,0.43,0,0.5,0.22,0.4,0.58,0.45,0.26,0.18],
[0,0.22,0,0.31,0.53,0,0.11,0.59,0.45,0,0,0,0,0.26,0.4,0.48],
[0,0.22,0,0.31,0.53,0,0.11,0.59,0.45,0,0,0,0,0.26,0.4,0.48],
[0,0.55,0.01,0.28,0.49,0.37,0.34,0.48,0.11,0.3,0.1,0,0.43,0,0,0.39],
[0,0.19,0.53,0.54,0.48,0,0.27,0.25,0.09,0,0.05,0.32,0.3,0,0.16,0],
[0.02,0.48,0,0.2,0.45,0.52,0,0.41,0.26,0.28,0.57,0.17,0.16,0.26,0,0.14],
[0.02,0.48,0,0.2,0.45,0.52,0,0.41,0.26,0.28,0.57,0.17,0.16,0.26,0,0.14],
[0.28,0.18,0.62,0.54,0.47,0.4,0.08,0.01,0.17,0.63,0.13,0.3,0.21,0.3,0,0],
[0.22,0.4,0.59,0.45,0.22,0.31,0.15,0.48,0.15,0.49,0.44,0.37,0,0.33,0,0.35],
[0.22,0.4,0.59,0.45,0.22,0.31,0.15,0.48,0.15,0.49,0.44,0.37,0,0.33,0,0.35],
[0.23,0.54,0.06,0.65,0.5,0.17,0.37,0.52,0.32,0.31,0.33,0.25,0,0,0.23,0],
[0.49,0,0.69,0.39,0.52,0.51,0.08,0.36,0.03,0.42,0.13,0,0.59,0,0.06,0.17],
[0.47,0.32,0.62,0.6,0,0.21,0.4,0.41,0.33,0,0.32,0.44,0.26,0.49,0.04,0],
[0.47,0.32,0.62,0.6,0,0.21,0.4,0.41,0.33,0,0.32,0.44,0.26,0.49,0.04,0],
[0.14,0.07,0.35,0.63,0,0.37,0.62,0.22,0.04,0.49,0,0,0.48,0.04,0.13,0.06],
[0.26,0,0.32,0,0.68,0.28,0.49,0.4,0.35,0.23,0,0.2,0,0.3,0,0.51],
[0.26,0,0.32,0,0.68,0.28,0.49,0.4,0.35,0.23,0,0.2,0,0.3,0,0.51],
[0.29,0.24,0.28,0.66,0,0,0.5,0.1,0.56,0.15,0.52,0,0.25,0.21,0.01,0.12],
[0.17,0,0,0.38,0,0.14,0.27,0,0.51,0.09,0.11,0.38,0,0.15,0.14,0],
[0.06,0.48,0.45,0.01,0.16,0.44,0.21,0.47,0.37,0.55,0.16,0.35,0.16,0.4,0.43,0.07],
[0.06,0.48,0.45,0.01,0.16,0.44,0.21,0.47,0.37,0.55,0.16,0.35,0.16,0.4,0.43,0.07],
[0.24,0.41,0.58,0.47,0.5,0.31,0.53,0.05,0,0.39,0.47,0,0.15,0,0.34,0.42],
[0,0.51,0,0.56,0,0.28,0,0.44,0.28,0.4,0.41,0,0,0,0,0.17],
[0,0.51,0,0.56,0,0.28,0,0.44,0.28,0.4,0.41,0,0,0,0,0.17],
[0.37,0.33,0.66,0.56,0.29,0,0.4,0.14,0.2,0.2,0.12,0.03,0.18,0,0.33,0.18],
[0.41,0.32,0.58,0.51,0.51,0.45,0.5,0.48,0,0.29,0.21,0.21,0.53,0.27,0,0],
[0.53,0.12,0.61,0.33,0.46,0,0.58,0.34,0.32,0.22,0.4,0.35,0.5,0.48,0.35,0.01],
[0.46,0.4,0.56,0.37,0.52,0.67,0,0.52,0.31,0.22,0.13,0.6,0.47,0.63,0.32,0.36],
[0.01,0.06,0,0,0,0,0.47,0.12,0.07,0.24,0.06,0.25,0.6,0.33,0.1,0.45],
[0.31,0,0.35,0,0.27,0.43,0.15,0.34,0.4,0.1,0.18,0.51,0.15,0.3,0.07,0.62],
[0,0.11,0,0.29,0.05,0,0.44,0,0.5,0.45,0.31,0.23,0,0.08,0.23,0.25],
[0,0.11,0,0.29,0.05,0,0.44,0,0.5,0.45,0.31,0.23,0,0.08,0.23,0.25],
[0,0.07,0.05,0.05,0.47,0,0.34,0,0.27,0,0.14,0.05,0.44,0.46,0.57,0.26],
[0,0.07,0.05,0.05,0.47,0,0.34,0,0.27,0,0.14,0.05,0.44,0.46,0.57,0.26],
[0,0.34,0,0.38,0.05,0.16,0.55,0.13,0.27,0.35,0.42,0.31,0.6,0.41,0.32,0.02],
[0.02,0,0,0.52,0.38,0,0.35,0.17,0,0.46,0.44,0,0.69,0.34,0.03,0.41],
[0.02,0,0,0.52,0.38,0,0.35,0.17,0,0.46,0.44,0,0.69,0.34,0.03,0.41],
[0.36,0.31,0.47,0.29,0.41,0.25,0.13,0.09,0.43,0.36,0,0.42,0.14,0.56,0,0.34],
[0.36,0.31,0.47,0.29,0.41,0.25,0.13,0.09,0.43,0.36,0,0.42,0.14,0.56,0,0.34],
[0.08,0.11,0,0.22,0,0.19,0,0.48,0,0.11,0,0.42,0,0.34,0.35,0.42],
[0.02,0.14,0.32,0.33,0.42,0.37,0.56,0.29,0.35,0.17,0.33,0,0.03,0,0.5,0.48],
[0.29,0.41,0.35,0.62,0.37,0.04,0.51,0.09,0.6,0.24,0.32,0,0.11,0.33,0.52,0.18],
[0.17,0,0.23,0.2,0.68,0.46,0.51,0,0.45,0.47,0.36,0.18,0.51,0,0.52,0.52],
[0,0,0.03,0.15,0.27,0.73,0.38,0,0.45,0.44,0,0.2,0,0.48,0,0.15],
[0.39,0,0.42,0,0.74,0.53,0.53,0.35,0.53,0.44,0.31,0.16,0.13,0,0.31,0.2],
[0.39,0,0.42,0,0.74,0.53,0.53,0.35,0.53,0.44,0.31,0.16,0.13,0,0.31,0.2],
[0.12,0.01,0.25,0,0.55,0.34,0.38,0.42,0.5,0.29,0.29,0.23,0.4,0.49,0.41,0],
[0,0,0,0,0,0.44,0.62,0.5,0,0.47,0,0.32,0.23,0.4,0,0.28],
[0,0,0,0,0,0.44,0.62,0.5,0,0.47,0,0.32,0.23,0.4,0,0.28],
[0,0.16,0.08,0.1,0,0.29,0.41,0.53,0,0.32,0.33,0.09,0.49,0,0,0.16],
[0.19,0.22,0.25,0,0.12,0,0.55,0,0,0.32,0,0.21,0.28,0.33,0,0.16],
[0,0,0.11,0.42,0.73,0.5,0.42,0.48,0.56,0,0.47,0.16,0.08,0.17,0.31,0.46],
[0,0,0.11,0.42,0.73,0.5,0.42,0.48,0.56,0,0.47,0.16,0.08,0.17,0.31,0.46],
[0.32,0.25,0.39,0.62,0.28,0.34,0.53,0.54,0.48,0.15,0.31,0.12,0,0,0.38,0.16],
[0.03,0,0.08,0.1,0.55,0,0.32,0.55,0,0.17,0.07,0.34,0.09,0,0,0.19],
[0.18,0,0.15,0.1,0.45,0.66,0,0.32,0.27,0.04,0.14,0.07,0,0.11,0.35,0.43],
[0.18,0,0.15,0.1,0.45,0.66,0,0.32,0.27,0.04,0.14,0.07,0,0.11,0.35,0.43],
[0.33,0.09,0.36,0.27,0.62,0.68,0.5,0.11,0.23,0.22,0.38,0,0.19,0.06,0.27,0.43],
[0.27,0,0.34,0,0.73,0.61,0.64,0.21,0.33,0.37,0.4,0.13,0.26,0.03,0,0],
[0.27,0,0.34,0,0.73,0.61,0.64,0.21,0.33,0.37,0.4,0.13,0.26,0.03,0,0],
[0,0.11,0,0.26,0.3,0.7,0.59,0,0.39,0.2,0,0.44,0.49,0.13,0.2,0.15],
[0,0.18,0,0.3,0.35,0.03,0.62,0.58,0.28,0.16,0,0.17,0.48,0.21,0.24,0.12],
[0,0.22,0,0.28,0,0.42,0.62,0.49,0,0,0.03,0.23,0,0.1,0.12,0.38],
[0,0,0,0,0.09,0.21,0,0.39,0.08,0.37,0.04,0.36,0,0,0.11,0.09],
[0,0,0,0,0.09,0.21,0,0.39,0.08,0.37,0.04,0.36,0,0,0.11,0.09],
[0.27,0.05,0.22,0.11,0.39,0.33,0.64,0.59,0.65,0.34,0,0.12,0,0.34,0.38,0.54],
[0.27,0.05,0.22,0.11,0.39,0.33,0.64,0.59,0.65,0.34,0,0.12,0,0.34,0.38,0.54],
[0.15,0,0.2,0.02,0.26,0.09,0.4,0.7,0.64,0,0.29,0.16,0.15,0.24,0.36,0.33],
[0.23,0.09,0.26,0.19,0.4,0.31,0.47,0.66,0.56,0.23,0.41,0.2,0.12,0.12,0.05,0],
[0.23,0.09,0.26,0.19,0.4,0.31,0.47,0.66,0.56,0.23,0.41,0.2,0.12,0.12,0.05,0],
[0.27,0,0.31,0.09,0.48,0.3,0,0.56,0.35,0.41,0.52,0.29,0,0.08,0.43,0.09],
[0.3,0,0.33,0,0.67,0.35,0.42,0.43,0,0.24,0.54,0,0.15,0,0.31,0],
[0.17,0.1,0.16,0,0.06,0.68,0.17,0.16,0,0.13,0.47,0,0.25,0,0.09,0.07],
[0.17,0.1,0.16,0,0.06,0.68,0.17,0.16,0,0.13,0.47,0,0.25,0,0.09,0.07],
[0,0.07,0.04,0.03,0.41,0.54,0.41,0.52,0,0.3,0,0.27,0.31,0.43,0.16,0.2],
[0,0,0,0,0.15,0.17,0,0.49,0,0.29,0.24,0.09,0.39,0.07,0.11,0.13],
[0,0,0,0,0.15,0.17,0,0.49,0,0.29,0.24,0.09,0.39,0.07,0.11,0.13],
[0,0,0,0,0.13,0.32,0,0.3,0.15,0,0.17,0.42,0.63,0.52,0,0.19],
[0.09,0,0,0,0.13,0.24,0.51,0.7,0.5,0.04,0.13,0,0.42,0.34,0.47,0.34],
[0,0.23,0.08,0.26,0.25,0.46,0,0.65,0.58,0.09,0.36,0.21,0.32,0,0.63,0.62],
[0,0.23,0.08,0.26,0.25,0.46,0,0.65,0.58,0.09,0.36,0.21,0.32,0,0.63,0.62],
[0,0,0,0.01,0,0,0,0.57,0.2,0.56,0.15,0.39,0.19,0.19,0.49,0.3],
[0,0,0,0.01,0,0,0,0.57,0.2,0.56,0.15,0.39,0.19,0.19,0.49,0.3],
[0,0.02,0,0.02,0,0.15,0,0.01,0.15,0.58,0,0.31,0.04,0.2,0.07,0.36],
[0,0.1,0.02,0.23,0.16,0,0.2,0.02,0.3,0.51,0.63,0.21,0.13,0.13,0.17,0.16],
[0.41,0.39,0.26,0.39,0,0.61,0.3,0.35,0.3,0.1,0.39,0.21,0.38,0.34,0.03,0.29],
[0.6,0.61,0.54,0.33,0.44,0.66,0.39,0.49,0.18,0.5,0.29,0.17,0.44,0,0.24,0.17],
[0.6,0.61,0.54,0.33,0.44,0.66,0.39,0.49,0.18,0.5,0.29,0.17,0.44,0,0.24,0.17],
[0,0.69,0.53,0.48,0.47,0.52,0.35,0.49,0.15,0.34,0.35,0.24,0.27,0.14,0.15,0],
[0.45,0.67,0.48,0.24,0.18,0,0.27,0.38,0.23,0,0,0,0,0.1,0.08,0.21],
[0.15,0.19,0.58,0.71,0.2,0.32,0.29,0.29,0.29,0.05,0.19,0.49,0,0,0.21,0.5],
[0.15,0.19,0.58,0.71,0.2,0.32,0.29,0.29,0.29,0.05,0.19,0.49,0,0,0.21,0.5],
[0.17,0.66,0.03,0.19,0.68,0.31,0.4,0.4,0.09,0,0,0.2,0.41,0.43,0.17,0.47],
[0.23,0.69,0.53,0.5,0.58,0.35,0,0.51,0.23,0.29,0,0,0.28,0.25,0.32,0],
[0,0.19,0.28,0.26,0,0.62,0.38,0.37,0.15,0.38,0.52,0.19,0.33,0.37,0,0.46],
[0,0.19,0.28,0.26,0,0.62,0.38,0.37,0.15,0.38,0.52,0.19,0.33,0.37,0,0.46],
[0.25,0.33,0,0.34,0.54,0.57,0.07,0.63,0.19,0.23,0.38,0.36,0.45,0,0.42,0.37],
[0.04,0,0.16,0.48,0.58,0,0.51,0.65,0,0.33,0.47,0,0.05,0.34,0.48,0.12],
[0.44,0,0.59,0.44,0.41,0.43,0.32,0.33,0.03,0.31,0.25,0.56,0.21,0.35,0,0.15],
[0.4,0.14,0.59,0.66,0,0.31,0,0,0.37,0.15,0.29,0.57,0.48,0.39,0.16,0.3],
[0.44,0.17,0.61,0.65,0.52,0.4,0.41,0,0.35,0.54,0.33,0.44,0.39,0,0.37,0.12],
[0.44,0.17,0.61,0.65,0.52,0.4,0.41,0,0.35,0.54,0.33,0.44,0.39,0,0.37,0.12],
[0.4,0.25,0.5,0.64,0.48,0.07,0.57,0.53,0.45,0.13,0.48,0.22,0.35,0.1,0.09,0.21],
[0,0.23,0.1,0.32,0.42,0.35,0.41,0.46,0.24,0.43,0.31,0.52,0.42,0.22,0.32,0.23],
[0,0.23,0.1,0.32,0.42,0.35,0.41,0.46,0.24,0.43,0.31,0.52,0.42,0.22,0.32,0.23],
[0,0.4,0.33,0.2,0.26,0.35,0.42,0.15,0.36,0.23,0.1,0.43,0,0.33,0,0.54],
[0,0,0.42,0,0.61,0,0.26,0,0.26,0.17,0.18,0.33,0.2,0,0.12,0.42],
[0.01,0,0.21,0.34,0,0.63,0.22,0.15,0,0,0.63,0.24,0,0,0.27,0.29],
[0.01,0,0.21,0.34,0,0.63,0.22,0.15,0,0,0.63,0.24,0,0,0.27,0.29],
[0.42,0,0.47,0.34,0.61,0.41,0.36,0,0.19,0.53,0.45,0.15,0.44,0.14,0.3,0],
[0,0,0.14,0.13,0.57,0.66,0.16,0.45,0.4,0.41,0.46,0,0.04,0.31,0,0],
[0.42,0.42,0.59,0.32,0.54,0.1,0.54,0.48,0.02,0,0,0.57,0.34,0.36,0.34,0.1],
[0,0.24,0.36,0.67,0.36,0.49,0.53,0.49,0.29,0.42,0.23,0.39,0.43,0.26,0.24,0.09],
[0.52,0.03,0.67,0.3,0.47,0.5,0.38,0.29,0.1,0.39,0.44,0.02,0.62,0.13,0.16,0],
[0.52,0.03,0.67,0.3,0.47,0.5,0.38,0.29,0.1,0.39,0.44,0.02,0.62,0.13,0.16,0],
[0,0,0,0.64,0.07,0.37,0,0.45,0,0.5,0.01,0.1,0.21,0.12,0.13,0.3],
[0,0.29,0,0.53,0.48,0.38,0.4,0.4,0.65,0.17,0.17,0.05,0,0,0,0.39],
[0.24,0,0.18,0.43,0.54,0.26,0.43,0.31,0.57,0.48,0.18,0.61,0.44,0,0.23,0.42],
[0.24,0,0.18,0.43,0.54,0.26,0.43,0.31,0.57,0.48,0.18,0.61,0.44,0,0.23,0.42],
[0.12,0.04,0.24,0.53,0.51,0.45,0,0.47,0.34,0.24,0.45,0.43,0.54,0.36,0.09,0.43],
[0.28,0.4,0.21,0.33,0.34,0,0.16,0.44,0.29,0.42,0.32,0.39,0.53,0.18,0.41,0],
[0,0.49,0.11,0.26,0.04,0,0.31,0.54,0.46,0.2,0.51,0,0.52,0.29,0.05,0.26],
[0,0.49,0.11,0.26,0.04,0,0.31,0.54,0.46,0.2,0.51,0,0.52,0.29,0.05,0.26],
[0.04,0,0.44,0.36,0,0.07,0.1,0.18,0.36,0.37,0.35,0,0,0.19,0,0.23],
[0.35,0.42,0.33,0.52,0.37,0.56,0.36,0.39,0.35,0.28,0.47,0.49,0.34,0.41,0.34,0.08],
[0.35,0.42,0.33,0.52,0.37,0.56,0.36,0.39,0.35,0.28,0.47,0.49,0.34,0.41,0.34,0.08],
[0.35,0.17,0.48,0.17,0.28,0.42,0.49,0.46,0.21,0.54,0,0.31,0.59,0.13,0.41,0.09],
[0.25,0.16,0.33,0.56,0.28,0.44,0.6,0,0.64,0.24,0,0.43,0.67,0.08,0.25,0.34],
[0.25,0.16,0.33,0.56,0.28,0.44,0.6,0,0.64,0.24,0,0.43,0.67,0.08,0.25,0.34],
[0.4,0.04,0.47,0.47,0.51,0.48,0,0.48,0.18,0,0.3,0.55,0.63,0,0.17,0.4],
[0.23,0,0.37,0.11,0.68,0,0.32,0.37,0.3,0.29,0,0.56,0.52,0.3,0.37,0.05],
[0,0.3,0.01,0.57,0.22,0.34,0.31,0.14,0.62,0.01,0.38,0.39,0.34,0.31,0,0.15],
[0,0.3,0.01,0.57,0.22,0.34,0.31,0.14,0.62,0.01,0.38,0.39,0.34,0.31,0,0.15],
[0,0.14,0,0.25,0.49,0.34,0.11,0.6,0.27,0.37,0,0.05,0.45,0.02,0.31,0.02],
[0.15,0,0.16,0,0.42,0.71,0.12,0.4,0.38,0.5,0.26,0.43,0.15,0,0.43,0],
[0.15,0,0.16,0,0.42,0.71,0.12,0.4,0.38,0.5,0.26,0.43,0.15,0,0.43,0],
[0.45,0,0.51,0.08,0.63,0.07,0.51,0.41,0.3,0.42,0.45,0.22,0.24,0.11,0.06,0.41],
[0.14,0.05,0.04,0,0.56,0.61,0.48,0,0.06,0,0.51,0.17,0,0.27,0.5,0.32],
[0.07,0.34,0.36,0.53,0.48,0.22,0.41,0.18,0,0,0.4,0.53,0.1,0,0.35,0.38],
[0.07,0.34,0.36,0.53,0.48,0.22,0.41,0.18,0,0,0.4,0.53,0.1,0,0.35,0.38],
[0.43,0.05,0.65,0.5,0.45,0.24,0.43,0.35,0.44,0.43,0.14,0.52,0.41,0.27,0,0.05],
[0.1,0.01,0.18,0.76,0,0.46,0,0.2,0.56,0.43,0.25,0.49,0.5,0.33,0,0],
[0.1,0.01,0.18,0.76,0,0.46,0,0.2,0.56,0.43,0.25,0.49,0.5,0.33,0,0],
[0.43,0.31,0.6,0.44,0.49,0.25,0.07,0.02,0.56,0,0.29,0.41,0,0,0.23,0.38],
[0,0.04,0.27,0,0.62,0.39,0.1,0.35,0.14,0.11,0.44,0.36,0,0.18,0.34,0.3],
[0,0.38,0,0.38,0.4,0.33,0.16,0,0.43,0.37,0,0.56,0.49,0.22,0.35,0.5],
[0,0.38,0,0.38,0.4,0.33,0.16,0,0.43,0.37,0,0.56,0.49,0.22,0.35,0.5],
[0.01,0.27,0.14,0.51,0.05,0,0.02,0.51,0.45,0.43,0,0.58,0.15,0.17,0.09,0.42],
[0.22,0,0.24,0.33,0.63,0.17,0.22,0,0.16,0.36,0.52,0.45,0.38,0,0.43,0.34],
[0.06,0.25,0,0.41,0.48,0.6,0.05,0.33,0.05,0.18,0.41,0.12,0.27,0.26,0.17,0.46],
[0.06,0.25,0,0.41,0.48,0.6,0.05,0.33,0.05,0.18,0.41,0.12,0.27,0.26,0.17,0.46],
[0.18,0.18,0.22,0.38,0.51,0.61,0.3,0,0.38,0.52,0.27,0.44,0.09,0.25,0.39,0],
[0.02,0.35,0,0.45,0.18,0.65,0.53,0.49,0.27,0.29,0,0.35,0.57,0,0,0],
[0.02,0.35,0,0.45,0.18,0.65,0.53,0.49,0.27,0.29,0,0.35,0.57,0,0,0],
[0,0.4,0,0.51,0,0.72,0,0.43,0,0,0.29,0.02,0.2,0.04,0,0.03],
[0,0.26,0,0.22,0,0.68,0.46,0.5,0,0.24,0,0.34,0.43,0.16,0,0.05],
[0,0.26,0,0.22,0,0.68,0.46,0.5,0,0.24,0,0.34,0.43,0.16,0,0.05],
[0,0.05,0.01,0.32,0.08,0.41,0.38,0.25,0.55,0.17,0.1,0.34,0.33,0.09,0.24,0],
[0,0.05,0.01,0.32,0.08,0.41,0.38,0.25,0.55,0.17,0.1,0.34,0.33,0.09,0.24,0],
[0.16,0,0.26,0.03,0.26,0,0.01,0.4,0.09,0,0.01,0.34,0.17,0.09,0.32,0.09],
[0.16,0,0.26,0.03,0.26,0,0.01,0.4,0.09,0,0.01,0.34,0.17,0.09,0.32,0.09],
[0.02,0,0.09,0,0.3,0.14,0,0.34,0.48,0.14,0.13,0.24,0.21,0.23,0,0.45],
[0.07,0,0.08,0.13,0.4,0.19,0.46,0.44,0.16,0.3,0,0.33,0.34,0.13,0.41,0],
[0.22,0,0.23,0,0.2,0.62,0.26,0.34,0.13,0.51,0.12,0.39,0,0.32,0.1,0.51],
[0.22,0,0.23,0,0.2,0.62,0.26,0.34,0.13,0.51,0.12,0.39,0,0.32,0.1,0.51],
[0.3,0,0.36,0.03,0.45,0.05,0.28,0.07,0.28,0.23,0.62,0,0.02,0.01,0.35,0.43],
[0,0,0,0.16,0,0.29,0.71,0.08,0,0.26,0,0.29,0,0.11,0.18,0.12],
[0,0,0,0.16,0,0.29,0.71,0.08,0,0.26,0,0.29,0,0.11,0.18,0.12],
[0,0,0.07,0,0.3,0,0.75,0.31,0,0.3,0.23,0.41,0.48,0,0.11,0],
[0.17,0.15,0.18,0.19,0.35,0.49,0.74,0.16,0.19,0.13,0.07,0.41,0.46,0.19,0.14,0.03],
[0.03,0.11,0.09,0.18,0.17,0.32,0.42,0,0.5,0,0.03,0.32,0.07,0,0.25,0.59],
[0.03,0.11,0.09,0.18,0.17,0.32,0.42,0,0.5,0,0.03,0.32,0.07,0,0.25,0.59],
[0,0.18,0,0.3,0,0.44,0,0.4,0.02,0.35,0.19,0.29,0,0,0,0.4],
[0,0.22,0,0.2,0.12,0.42,0.07,0.5,0.4,0.39,0.03,0,0.3,0,0.35,0.57],
[0,0.22,0,0.2,0.12,0.42,0.07,0.5,0.4,0.39,0.03,0,0.3,0,0.35,0.57],
[0.11,0,0.12,0.3,0.1,0,0,0,0.46,0,0,0.02,0.11,0,0.43,0.03],
[0.33,0,0.41,0,0.53,0.54,0.45,0.39,0.22,0.48,0.37,0.46,0.34,0.23,0.24,0.33],
[0,0,0.1,0.04,0.25,0.66,0.17,0.3,0.15,0.14,0.29,0,0.25,0,0.27,0.49],
[0,0,0.1,0.04,0.25,0.66,0.17,0.3,0.15,0.14,0.29,0,0.25,0,0.27,0.49],
[0.35,0,0.35,0.02,0.52,0.36,0.38,0,0,0.35,0.17,0.1,0.09,0,0.42,0.1],
[0,0.39,0,0.48,0,0.65,0.46,0.6,0.35,0.12,0,0,0.27,0.22,0.24,0.17],
[0,0.39,0,0.48,0,0.65,0.46,0.6,0.35,0.12,0,0,0.27,0.22,0.24,0.17],
[0,0.39,0,0.5,0.2,0.67,0.26,0.65,0,0.09,0,0.6,0.23,0.21,0,0],
[0,0.36,0.04,0.42,0.29,0.63,0.29,0.45,0.07,0,0.05,0.52,0,0.34,0,0.06],
[0,0,0,0,0,0,0.11,0.12,0.37,0.01,0.06,0.17,0.1,0,0.42,0.57],
[0,0,0,0,0,0,0.11,0.12,0.37,0.01,0.06,0.17,0.1,0,0.42,0.57],
[0,0.13,0,0.21,0.1,0.04,0.25,0.5,0,0.4,0,0.08,0.32,0,0.01,0.46],
[0,0.17,0.05,0.18,0.22,0.38,0,0.51,0.52,0.19,0,0,0.13,0.02,0,0.6],
[0,0,0,0,0.01,0.17,0.29,0,0.31,0.5,0.19,0.37,0.12,0.13,0.34,0.66],
[0,0,0,0,0.01,0.17,0.29,0,0.31,0.5,0.19,0.37,0.12,0.13,0.34,0.66],
[0.04,0,0,0,0.05,0.03,0,0.27,0.36,0.27,0.47,0.38,0,0.17,0.24,0.4],
[0,0.12,0,0.14,0.07,0,0,0.3,0,0.45,0.47,0,0.29,0,0.38,0.38],
[0,0.12,0,0.14,0.07,0,0,0.3,0,0.45,0.47,0,0.29,0,0.38,0.38],
[0,0.19,0,0.26,0.12,0.4,0,0.37,0,0.67,0.24,0.49,0,0,0,0.21],
[0.64,0,0.56,0,0.44,0.42,0.05,0.38,0.33,0.22,0,0,0,0.45,0.15,0.26],
[0.5,0.48,0.67,0,0.59,0.04,0.55,0.4,0,0.34,0.06,0.33,0.4,0.21,0.23,0.37],
[0.5,0.48,0.67,0,0.59,0.04,0.55,0.4,0,0.34,0.06,0.33,0.4,0.21,0.23,0.37],
[0.43,0.5,0.55,0.25,0.09,0.57,0.63,0.24,0.08,0,0,0.54,0.2,0.36,0,0.35],
[0.22,0,0.6,0,0.6,0.13,0.17,0.42,0.48,0,0.25,0,0,0.33,0,0],
[0.22,0,0.6,0,0.6,0.13,0.17,0.42,0.48,0,0.25,0,0,0.33,0,0],
[0.13,0.06,0.45,0.73,0.61,0.31,0.33,0,0.37,0.28,0.24,0.35,0.46,0.33,0.28,0.13],
[0.09,0.7,0.28,0.29,0.6,0.64,0.21,0.51,0,0.12,0,0.22,0.35,0,0.33,0],
[0.28,0,0.37,0,0.52,0.54,0.37,0,0.53,0.39,0.28,0.2,0.25,0,0.44,0.27],
[0.28,0,0.37,0,0.52,0.54,0.37,0,0.53,0.39,0.28,0.2,0.25,0,0.44,0.27],
[0.29,0.19,0.39,0.54,0.5,0.56,0.46,0.44,0.12,0.49,0.56,0.07,0.08,0.2,0,0.1],
[0.4,0.39,0.56,0.56,0.43,0.52,0.55,0.51,0.25,0.21,0.36,0.36,0,0.24,0.24,0.4],
[0.4,0.39,0.56,0.56,0.43,0.52,0.55,0.51,0.25,0.21,0.36,0.36,0,0.24,0.24,0.4],
[0.31,0,0.65,0.19,0.44,0.52,0.09,0.45,0.27,0,0.15,0.28,0.34,0,0.53,0.26],
[0.33,0.23,0.43,0.23,0.47,0.58,0.11,0.58,0,0.5,0.28,0.05,0.55,0.22,0.29,0.34],
[0,0.15,0,0.52,0.22,0.27,0.51,0.23,0.37,0.35,0.48,0.4,0.5,0.31,0,0.17],
[0,0.15,0,0.52,0.22,0.27,0.51,0.23,0.37,0.35,0.48,0.4,0.5,0.31,0,0.17],
[0.46,0,0.5,0.6,0.46,0.21,0.35,0.42,0.24,0.64,0.24,0.47,0.33,0.47,0.08,0.38],
[0.3,0.46,0.1,0.32,0.12,0.17,0.34,0.41,0.35,0.05,0,0.11,0.41,0.11,0.46,0.15],
[0.3,0.46,0.1,0.32,0.12,0.17,0.34,0.41,0.35,0.05,0,0.11,0.41,0.11,0.46,0.15],
[0.28,0.4,0.42,0.59,0.27,0.11,0.52,0.44,0.35,0.4,0.17,0.1,0.47,0.31,0.04,0.44],
[0,0.41,0.65,0.39,0.41,0.01,0,0,0.46,0.38,0.45,0.37,0.34,0.02,0.31,0.35],
[0.04,0.01,0,0.44,0.27,0.21,0.31,0.5,0.37,0.58,0.57,0.12,0.15,0,0.29,0.45],
[0.04,0.01,0,0.44,0.27,0.21,0.31,0.5,0.37,0.58,0.57,0.12,0.15,0,0.29,0.45],
[0,0.31,0.63,0.45,0.56,0.31,0,0.41,0.29,0.56,0.25,0,0.16,0.06,0.38,0.16],
[0.42,0.2,0.73,0.46,0,0.19,0.07,0.5,0.35,0.47,0.44,0.28,0.26,0,0.16,0.15],
[0.42,0.2,0.73,0.46,0,0.19,0.07,0.5,0.35,0.47,0.44,0.28,0.26,0,0.16,0.15],
[0.14,0.59,0.47,0.65,0,0.45,0.28,0.38,0.3,0.37,0.57,0.04,0.18,0,0.4,0.26],
[0.46,0.33,0.63,0.55,0.51,0.19,0.36,0.46,0.27,0.42,0.3,0.46,0.52,0.45,0.08,0.31],
[0.45,0.27,0.61,0.75,0.53,0.43,0.51,0.42,0.27,0.32,0.46,0.47,0.29,0.29,0,0],
[0.45,0.27,0.61,0.75,0.53,0.43,0.51,0.42,0.27,0.32,0.46,0.47,0.29,0.29,0,0],
[0.2,0,0.33,0.64,0.09,0.08,0.48,0,0.01,0.43,0.15,0.46,0.51,0.51,0.22,0.14],
[0.15,0.38,0.35,0.67,0,0.49,0,0.39,0.62,0,0.07,0.24,0,0,0.18,0.46],
[0.15,0.38,0.35,0.67,0,0.49,0,0.39,0.62,0,0.07,0.24,0,0,0.18,0.46],
[0.23,0.27,0.09,0.56,0.48,0,0.04,0.68,0,0.48,0.29,0.12,0.43,0.28,0,0],
[0.23,0.27,0.09,0.56,0.48,0,0.04,0.68,0,0.48,0.29,0.12,0.43,0.28,0,0],
[0.2,0.53,0.39,0.38,0.4,0,0.39,0.34,0.53,0.26,0.57,0,0.29,0.41,0.38,0],
[0.2,0.53,0.39,0.38,0.4,0,0.39,0.34,0.53,0.26,0.57,0,0.29,0.41,0.38,0],
[0.15,0.29,0.61,0.58,0,0.59,0.32,0.64,0.39,0.51,0.55,0.07,0.28,0,0.29,0.24],
[0.01,0.51,0.02,0.72,0.44,0.34,0.31,0.08,0,0.58,0.12,0,0,0.27,0.47,0.24],
[0.33,0.28,0.69,0.54,0.38,0.24,0.36,0.49,0.15,0.47,0,0,0.11,0.15,0.24,0.43],
[0.33,0.28,0.69,0.54,0.38,0.24,0.36,0.49,0.15,0.47,0,0,0.11,0.15,0.24,0.43],
[0.12,0.28,0.42,0.34,0.47,0.08,0.26,0.1,0.23,0.56,0.5,0.22,0.59,0,0.45,0],
[0.26,0.3,0.48,0.07,0.47,0.17,0,0.32,0.27,0.13,0.46,0.5,0.48,0.33,0,0.01],
[0.26,0.3,0.48,0.07,0.47,0.17,0,0.32,0.27,0.13,0.46,0.5,0.48,0.33,0,0.01],
[0.32,0,0.44,0.55,0.25,0.4,0.49,0.18,0.06,0.02,0,0.12,0.42,0,0,0],
[0,0.45,0,0.63,0.26,0.25,0.44,0.66,0.43,0.53,0.04,0.15,0.08,0.12,0,0.17],
[0,0.18,0,0.44,0.64,0,0.05,0.32,0.59,0,0.14,0,0.45,0.01,0.21,0.34],
[0,0.18,0,0.44,0.64,0,0.05,0.32,0.59,0,0.14,0,0.45,0.01,0.21,0.34],
[0.23,0.26,0.19,0.51,0.42,0.29,0.33,0.22,0.6,0,0.23,0.31,0.44,0.29,0.38,0],
[0.39,0,0.43,0.13,0.62,0.36,0.39,0.62,0.41,0.19,0.39,0,0.35,0.27,0.2,0.45],
[0.39,0,0.43,0.13,0.62,0.36,0.39,0.62,0.41,0.19,0.39,0,0.35,0.27,0.2,0.45],
[0.11,0.31,0.23,0.47,0.55,0.73,0.39,0.39,0.5,0.09,0.24,0.15,0,0,0.18,0.29],
[0.17,0.19,0.17,0,0.63,0.72,0.26,0,0.52,0.39,0.42,0.33,0.33,0.22,0.36,0.43],
[0,0.29,0,0.5,0.54,0,0.3,0.39,0,0.3,0.48,0.21,0.35,0.18,0.36,0.2],
[0,0.29,0,0.5,0.54,0,0.3,0.39,0,0.3,0.48,0.21,0.35,0.18,0.36,0.2],
[0.25,0.29,0.36,0.76,0.26,0.46,0.29,0.39,0.23,0.43,0.44,0.12,0.41,0.53,0.22,0.45],
[0.32,0.22,0.47,0.63,0.63,0.38,0.58,0.38,0,0.27,0.06,0.05,0.5,0.38,0.29,0.27],
[0.32,0.22,0.47,0.63,0.63,0.38,0.58,0.38,0,0.27,0.06,0.05,0.5,0.38,0.29,0.27],
[0.41,0,0.54,0.13,0.44,0.23,0.64,0.35,0,0.41,0,0,0.18,0.27,0,0.36],
[0.21,0,0.22,0.09,0.63,0.61,0.28,0.6,0.34,0.32,0.29,0.33,0.53,0.22,0.1,0],
[0.06,0.03,0,0.3,0,0,0.32,0,0.62,0,0.25,0,0,0,0.17,0.58],
[0.06,0.03,0,0.3,0,0,0.32,0,0.62,0,0.25,0,0,0,0.17,0.58],
[0,0,0,0.15,0.13,0.08,0.25,0.45,0.41,0,0.36,0.36,0.36,0,0,0.07],
[0.37,0.01,0.46,0.01,0.65,0.2,0.52,0.28,0.28,0.54,0.07,0.02,0.08,0,0.35,0.4],
[0.37,0.01,0.46,0.01,0.65,0.2,0.52,0.28,0.28,0.54,0.07,0.02,0.08,0,0.35,0.4],
[0,0.17,0,0.35,0.18,0.75,0.26,0,0.36,0.16,0.49,0.21,0.28,0,0,0.23],
[0.39,0,0.41,0.21,0.67,0.6,0.49,0.46,0.06,0.1,0.5,0.3,0,0.27,0.1,0.22],
[0.18,0.06,0.31,0.05,0.59,0.22,0.51,0.45,0.41,0.3,0.48,0,0.45,0.27,0,0],
[0.22,0.07,0.19,0.28,0.23,0.02,0.33,0.53,0.1,0.46,0.18,0,0.41,0.22,0,0.29],
[0,0,0,0.34,0.47,0,0.34,0.42,0.13,0.04,0,0.44,0.51,0.17,0.36,0.3],
[0.06,0.12,0,0.13,0,0.35,0.07,0.09,0.4,0.65,0,0,0,0,0.4,0.32],
[0.41,0,0.42,0,0.67,0.66,0.53,0.15,0.08,0.35,0.1,0,0,0.07,0.01,0.42],
[0.41,0,0.42,0,0.67,0.66,0.53,0.15,0.08,0.35,0.1,0,0,0.07,0.01,0.42],
[0.34,0,0.43,0,0.69,0.55,0.65,0.41,0.45,0.52,0.45,0.36,0.07,0.18,0.08,0.16],
[0.04,0.07,0.12,0.15,0.47,0.67,0.51,0.27,0.36,0.27,0.46,0,0.54,0,0,0.38],
[0.04,0.07,0.12,0.15,0.47,0.67,0.51,0.27,0.36,0.27,0.46,0,0.54,0,0,0.38],
[0,0.14,0,0.19,0,0,0.59,0.1,0,0.26,0.44,0,0.31,0,0.21,0.25],
[0,0.27,0,0.33,0,0.49,0,0.48,0.06,0,0.42,0,0.34,0.35,0,0.37],
[0,0,0,0,0,0.04,0.69,0.28,0,0.31,0.27,0.42,0.39,0.32,0,0],
[0,0,0,0,0,0.04,0.69,0.28,0,0.31,0.27,0.42,0.39,0.32,0,0],
[0,0.09,0.15,0.25,0.05,0.22,0.4,0.23,0.78,0.31,0.25,0,0,0,0.45,0.45],
[0.07,0,0.06,0.16,0.07,0.2,0.29,0.58,0.35,0.21,0.16,0,0,0.3,0.49,0.48],
[0.07,0,0.06,0.16,0.07,0.2,0.29,0.58,0.35,0.21,0.16,0,0,0.3,0.49,0.48],
[0,0.32,0,0.45,0.03,0.32,0.09,0.46,0.67,0.35,0.32,0.32,0.13,0.14,0.55,0.38],
[0.13,0.14,0.17,0.28,0.53,0.53,0.32,0.42,0.53,0.35,0.3,0,0.27,0.18,0.52,0.11],
[0.41,0,0.42,0.2,0.58,0.4,0.39,0.49,0.37,0.26,0.5,0,0,0,0,0.17],
[0.41,0,0.42,0.2,0.58,0.4,0.39,0.49,0.37,0.26,0.5,0,0,0,0,0.17],
[0.2,0.03,0.13,0,0.21,0.77,0.4,0.27,0.4,0.48,0.2,0.18,0.23,0.03,0.51,0.16],
[0.18,0.15,0.26,0.23,0.16,0.1,0.6,0,0,0.18,0,0.44,0.17,0.41,0,0.13],
[0.18,0.15,0.26,0.23,0.16,0.1,0.6,0,0,0.18,0,0.44,0.17,0.41,0,0.13],
[0,0.37,0,0.42,0,0.6,0.42,0.55,0.35,0.26,0,0,0.53,0.18,0.22,0],
[0.04,0.05,0.02,0,0.27,0.22,0.65,0.15,0.24,0,0.22,0.48,0.24,0.4,0,0.33],
[0.02,0.26,0.13,0.28,0.19,0.52,0.51,0.46,0.27,0,0.05,0.14,0.55,0.46,0,0.37],
[0.02,0.26,0.13,0.28,0.19,0.52,0.51,0.46,0.27,0,0.05,0.14,0.55,0.46,0,0.37],
[0,0.21,0,0.17,0,0.4,0.39,0.51,0.54,0.34,0.07,0.1,0,0.21,0.11,0.55],
[0.38,0,0.26,0.03,0.31,0.2,0,0.57,0.65,0.28,0,0.37,0.14,0,0.49,0.02],
[0.24,0.14,0,0.19,0,0.28,0,0.39,0.36,0.19,0.11,0,0.12,0,0.39,0.32],
[0.24,0.14,0,0.19,0,0.28,0,0.39,0.36,0.19,0.11,0,0.12,0,0.39,0.32],
[0,0,0,0.24,0.01,0.39,0.04,0.33,0.42,0.46,0.6,0.28,0,0.33,0.07,0.48],
[0,0.16,0,0.08,0.09,0.28,0.06,0.4,0.12,0.41,0.67,0.41,0.22,0,0.4,0.12],
[0,0.16,0,0.08,0.09,0.28,0.06,0.4,0.12,0.41,0.67,0.41,0.22,0,0.4,0.12],
[0.22,0.05,0.2,0.07,0.23,0.26,0.29,0.24,0.52,0.54,0.78,0.29,0.25,0.05,0,0.27],
[0.19,0.37,0.43,0.12,0,0.87,0.76,0.43,0.59,0.48,0.29,0.57,0.33,0.02,0,0.01],
[0.19,0.37,0.43,0.12,0,0.87,0.76,0.43,0.59,0.48,0.29,0.57,0.33,0.02,0,0.01],
[0.51,0.3,0.87,0.86,0.61,0.28,0.53,0.62,0.25,0.2,0.23,0,0,0,0.33,0.29],
[0.86,0.97,0.88,0.51,0.56,0,0.49,0.06,0,0.33,0.25,0.25,0,0.2,0.06,0],
[0.85,0.91,0.64,0.03,0,0.49,0.35,0.46,0.14,0.35,0,0.26,0,0.22,0,0],
[0.85,0.91,0.64,0.03,0,0.49,0.35,0.46,0.14,0.35,0,0.26,0,0.22,0,0],
[0.75,0.58,0.72,0.56,0,0.17,0,0.37,0.16,0.31,0.23,0.16,0.32,0,0,0.43],
[0.71,0.34,0.63,0.46,0.46,0.36,0.49,0.44,0.33,0.15,0.51,0.21,0.46,0.11,0.22,0.47],
[0.26,0.6,0,0.34,0.23,0.05,0.03,0.5,0.14,0.39,0,0.46,0.34,0.35,0.3,0.45],
[0.26,0.6,0,0.34,0.23,0.05,0.03,0.5,0.14,0.39,0,0.46,0.34,0.35,0.3,0.45],
[0.45,0.91,0,0.55,0.46,0.49,0.16,0.19,0.36,0.56,0.5,0,0.36,0,0.52,0.25],
[0.81,0.72,0.87,0.2,0.4,0.28,0.34,0.44,0.3,0.06,0.45,0,0.5,0,0.16,0],
[0.81,0.72,0.87,0.2,0.4,0.28,0.34,0.44,0.3,0.06,0.45,0,0.5,0,0.16,0],
[0,0.77,0.39,0.82,0.28,0.37,0.13,0.14,0.31,0.23,0.3,0.2,0.48,0.53,0,0.45],
[0.59,0.6,0.06,0.29,0.84,0.94,0.33,0.45,0.24,0,0.51,0.39,0.55,0.03,0.11,0.42],
[0.65,0.94,0.76,0.91,0.38,0.64,0.07,0,0.33,0.27,0,0.25,0.28,0.39,0,0.42]];